/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mgmap;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeTbl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.DupData;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.data.PatternColor;
import cgdp.recog.data.PatternTbl;
import cgdp.recog.data.ViewData;
import cgdp.recog.funccat.FunctionColorUtil;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.mgmap.Domain;
import cgdp.recog.mgmap.GeneClass;
import cgdp.recog.mgmap.RGMCondition;
import cgdp.recog.mgmap.ViewRangeItem;
import cgdp.recog.organism.Organism;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.system.OS;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.url.GeneUrlFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.Range;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;

class AlignmentMap
extends JPanel
implements MouseListener,
ActionListener {
    private static final ApplicationLogger logger = new ApplicationLogger(AlignmentMap.class);
    private static final int[] VIEW_RANGE_ITEMS = new int[]{100, 500, 1000, 2500, 5000, 10000, 25000, 50000};
    private static final Font IMAGE_FONT = new Font("Monospaced", 0, 10);
    private static final Font TITLE_FONT = new Font("Monospaced", 0, 12);
    private static final Color BACKGROUND_COLOR1 = Color.white;
    private static final Color BACKGROUND_COLOR2 = new Color(240, 240, 240);
    private MediatorImpl mediator;
    private ClusterTbl m_clusterTbl;
    private BufferedImage m_image;
    private List m_viewDataList;
    private Map organismLocusTagMap = new HashMap();
    private int m_sbW;
    private Map m_geneClassMap;
    private Map m_dupMap;
    private Map m_geneTblMap;
    private Map m_chromosomeTblMap;
    private RGMCondition rgmCondition;
    private ProgressImpl m_progressImpl;

    AlignmentMap(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.init();
        this.setLayout(null);
        this.addMouseListener(this);
    }

    private void init() {
        this.m_clusterTbl = null;
        this.m_image = null;
        this.m_viewDataList = new ArrayList();
        this.m_sbW = new JScrollBar((int)1).getPreferredSize().width;
        this.m_geneClassMap = null;
        this.m_progressImpl = null;
        this.m_dupMap = null;
        this.m_geneTblMap = new HashMap();
        this.m_chromosomeTblMap = new HashMap();
    }

    void updateValue(RGMCondition rGMCondition) {
        this.setRGMCondition(rGMCondition);
    }

    void setRGMCondition(RGMCondition rGMCondition) {
        this.rgmCondition = rGMCondition;
    }

    private boolean draw(Graphics2D graphics2D, Organism organism, ChromosomeTbl chromosomeTbl, GeneTbl geneTbl, String string, int n, int n2) {
        ArrayList<DupData> arrayList3;
        Object object;
        double d;
        Object object22;
        int n3;
        int n4;
        int n5;
        int n6;
        Gene gene;
        String string2 = organism.getOrganismCode();
        String string3 = string;
        int n7 = 1;
        if (GeneUtil.isDomain(string)) {
            string3 = GeneUtil.removeDomainNo(string);
            n7 = GeneUtil.getDomainNo(string);
        }
        if ((gene = (Gene)geneTbl.get(string3)) == null) {
            return false;
        }
        Chromosome chromosome = (Chromosome)chromosomeTbl.get(String.valueOf(gene.getChromId()));
        if (chromosome == null) {
            return false;
        }
        if (gene.getStart() > gene.getEnd() || gene.getRange() > chromosome.getLength()) {
            return false;
        }
        int n8 = chromosome.getLength();
        boolean bl = chromosome.isCircular();
        int n9 = gene.getStart() - this.rgmCondition.getZoomRange();
        int n10 = gene.getEnd() + this.rgmCondition.getZoomRange();
        int n11 = this.getDataHeight();
        graphics2D.setColor(this.getImageBackgroundColor(n2));
        graphics2D.fillRect(0, n, this.m_image.getWidth(), n11);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d2 = (double)(this.m_image.getWidth() - 10) / (double)(n10 - n9 + 1);
        ArrayList<Gene> arrayList2 = new ArrayList<Gene>();
        for (Gene gene2 : geneTbl.values()) {
            if (gene2.getStart() > gene2.getEnd() || gene2.getRange() > n8 || gene.equals(gene2) || gene.getChromId() != gene2.getChromId()) continue;
            if (gene2.getEnd() >= n9 && gene2.getStart() <= n10) {
                arrayList2.add(gene2);
                continue;
            }
            if (bl && n9 < 1) {
                n6 = n8 + n9;
                n5 = n8;
                if (gene2.getEnd() < n6 || gene2.getStart() > n5) continue;
                gene2.setStart(gene2.getStart() - n8);
                gene2.setEnd(gene2.getEnd() - n8);
                arrayList2.add(gene2);
                continue;
            }
            if (!bl || n10 <= n8) continue;
            n6 = 1;
            n5 = n10 - n8;
            if (gene2.getEnd() < n6 || gene2.getStart() > n5) continue;
            gene2.setStart(gene2.getStart() + n8);
            gene2.setEnd(gene2.getEnd() + n8);
            arrayList2.add(gene2);
        }
        final int n12 = gene.getDirection();
        Collections.sort(arrayList2, new Comparator(){

            public int compare(Object object, Object object2) {
                if (n12 == 1) {
                    return ((Gene)object).getStart() - ((Gene)object2).getStart();
                }
                return ((Gene)object2).getEnd() - ((Gene)object).getEnd();
            }
        });
        int n13 = this.getImageFontHeight();
        n6 = this.getTitleFontHeight();
        n5 = n + n6 + (this.rgmCondition.isShowLabel() ? n13 * 5 : n13);
        int n14 = n5 + 13;
        int n15 = n14 + 3 + 3;
        int n16 = n15 + 10;
        String string4 = this.mediator.getOrganismName(string2);
        if (bl) {
            n4 = n9 < 1 ? n8 + n9 : n9;
            n3 = n10 > n8 ? n10 - n8 : n10;
        } else {
            n4 = n9 < 1 ? 1 : n9;
            n3 = n10 > n8 ? n8 : n10;
        }
        graphics2D.setFont(TITLE_FONT);
        graphics2D.setColor(Color.black);
        int n17 = this.getTitleFontAscent();
        if (n12 == 1) {
            graphics2D.drawString(string4 + ": " + n4 + "-" + n3 + "(chromosome-" + chromosome.getName() + ")", 5, n + n17);
        } else {
            graphics2D.drawString(string4 + ": " + n3 + "-" + n4 + "(chromosome-" + chromosome.getName() + ")", 5, n + n17);
        }
        graphics2D.setFont(IMAGE_FONT);
        double d3 = n12 == 1 ? (double)(gene.getStart() - n9) * d2 + 5.0 : (double)(n10 - gene.getEnd()) * d2 + 5.0;
        double d4 = (double)(gene.getEnd() - gene.getStart() + 1) * d2;
        d4 = d4 < 1.0 ? 1.0 : d4;
        double d5 = 10.0;
        GeneClass geneClass = (GeneClass)this.m_geneClassMap.get(gene.getLocusTag());
        geneClass.setLength(gene.getEnd() - gene.getStart() + 1);
        boolean bl2 = this.setGenePosition(gene, geneClass);
        if (!bl2) {
            return false;
        }
        for (Object object22 : geneClass.getDomainList()) {
            Color color = this.getCentralGeneColor(organism, n7, (Domain)object22, this.rgmCondition.getColorType());
            graphics2D.setColor(color);
            double d6 = n12 == 1 ? (double)(((Domain)object22).getFrom() - n9) * d2 + 5.0 : (double)(n10 - ((Domain)object22).getTo()) * d2 + 5.0;
            d = (double)(((Domain)object22).getTo() - ((Domain)object22).getFrom() + 1) * d2;
            object = this.createGeneShape(n12, gene, d6, n5, d, d5, n9, n10, d2);
            if (n7 == ((Domain)object22).getNo() || !this.rgmCondition.isPatternColor()) {
                graphics2D.fill((Shape)object);
                continue;
            }
            arrayList3 = (ArrayList<DupData>)this.m_dupMap.get(String.valueOf(((Domain)object22).getClusterId()));
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<DupData>();
                this.m_dupMap.put(String.valueOf(((Domain)object22).getClusterId()), arrayList3);
            }
            DupData dupData = new DupData();
            dupData.setDataRect2D(this.createSimpleGeneShape(d3, n5, d4, d5));
            dupData.setDomainRect2D(this.createSimpleGeneShape(d6, n5, d, d5));
            dupData.setDrawShape((Shape)object);
            arrayList3.add(dupData);
        }
        graphics2D.setColor(Color.black);
        Shape shape = this.createGeneShape(n12, gene, d3, n5, d4, d5, n9, n10, d2);
        graphics2D.draw(shape);
        object22 = new ViewData();
        ((ViewData)object22).setObject(gene);
        ((ViewData)object22).setDataRect2D(this.createSimpleGeneShape(d3, n5, d4, d5));
        int n18 = this.getImageFontAscent();
        if (this.rgmCondition.isShowLabel()) {
            graphics2D.drawString(gene.getLocusTag(), (int)d3, n5 - n13 + n18);
            ((ViewData)object22).setNameRect(new Rectangle((int)d3, n5 - n13, fontMetrics.stringWidth(gene.getLocusTag()), n18));
        }
        this.m_viewDataList.add(object22);
        for (Gene gene3 : arrayList2) {
            List<DupData> list;
            d3 = n12 == 1 ? (double)(gene3.getStart() - n9) * d2 + 5.0 : (double)(n10 - gene3.getEnd()) * d2 + 5.0;
            d = this.getGeneStartY(n12, gene3.getDirection(), n5, n15);
            d4 = (double)(gene3.getEnd() - gene3.getStart() + 1) * d2;
            d4 = d4 < 1.0 ? 1.0 : d4;
            geneClass = (GeneClass)this.m_geneClassMap.get(gene3.getLocusTag());
            if (geneClass == null) {
                graphics2D.setColor(this.getNotIncludeClusterGeneColor(string2));
                object = this.createGeneShape(n12, gene3, d3, d, d4, d5, n9, n10, d2);
                graphics2D.fill((Shape)object);
            } else {
                geneClass.setLength(gene3.getEnd() - gene3.getStart() + 1);
                this.setGenePosition(gene3, geneClass);
                if (!this.rgmCondition.isPatternColor()) {
                    for (ArrayList<DupData> arrayList3 : geneClass.getDomainList()) {
                        graphics2D.setColor(this.getGeneColor(organism, (Domain)((Object)arrayList3)));
                        double d7 = n12 == 1 ? (double)(((Domain)((Object)arrayList3)).getFrom() - n9) * d2 + 5.0 : (double)(n10 - ((Domain)((Object)arrayList3)).getTo()) * d2 + 5.0;
                        double d8 = (double)(((Domain)((Object)arrayList3)).getTo() - ((Domain)((Object)arrayList3)).getFrom() + 1) * d2;
                        Shape shape2 = this.createGeneShape(n12, gene3, d7, d, d8, d5, n9, n10, d2);
                        graphics2D.fill(shape2);
                    }
                }
            }
            graphics2D.setColor(Color.black);
            object = this.createGeneShape(n12, gene3, d3, d, d4, d5, n9, n10, d2);
            graphics2D.draw((Shape)object);
            object22 = new ViewData();
            ((ViewData)object22).setObject(gene3);
            ((ViewData)object22).setDataRect2D(this.createSimpleGeneShape(d3, d, d4, d5));
            if (this.rgmCondition.isShowLabel()) {
                arrayList3 = n12 == 1 ? (gene3.getDirection() == 1 ? new Rectangle((int)d3, n5 - n13, fontMetrics.stringWidth(gene3.getLocusTag()), n18) : new Rectangle((int)d3, n16 + n13 - n18, fontMetrics.stringWidth(gene3.getLocusTag()), n18)) : (gene3.getDirection() == 1 ? new Rectangle((int)d3, n16 + n13 - n18, fontMetrics.stringWidth(gene3.getLocusTag()), n18) : new Rectangle((int)d3, n5 - n13, fontMetrics.stringWidth(gene3.getLocusTag()), n18));
                while (true) {
                    boolean bl3 = false;
                    list = this.m_viewDataList.iterator();
                    while (list.hasNext()) {
                        Rectangle rectangle = ((ViewData)list.next()).getNameRect();
                        if (((Rectangle)((Object)arrayList3)).y != rectangle.y || ((Rectangle)((Object)arrayList3)).x > rectangle.x + rectangle.width || ((Rectangle)((Object)arrayList3)).x + ((Rectangle)((Object)arrayList3)).width < rectangle.x) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) break;
                    if (n12 == 1) {
                        if (gene3.getDirection() == 1) {
                            ((Rectangle)((Object)arrayList3)).translate(0, -n13);
                            continue;
                        }
                        ((Rectangle)((Object)arrayList3)).translate(0, n13);
                        continue;
                    }
                    if (gene3.getDirection() == 1) {
                        ((Rectangle)((Object)arrayList3)).translate(0, n13);
                        continue;
                    }
                    ((Rectangle)((Object)arrayList3)).translate(0, -n13);
                }
                if (n12 == 1) {
                    if (gene3.getDirection() == 1) {
                        if (((Rectangle)((Object)arrayList3)).y >= n + n6) {
                            graphics2D.drawString(gene3.getLocusTag(), ((Rectangle)((Object)arrayList3)).x, ((Rectangle)((Object)arrayList3)).y + n18);
                        }
                    } else if (((Rectangle)((Object)arrayList3)).y < n + n11) {
                        graphics2D.drawString(gene3.getLocusTag(), ((Rectangle)((Object)arrayList3)).x, ((Rectangle)((Object)arrayList3)).y + n18);
                    }
                } else if (gene3.getDirection() == 1) {
                    if (((Rectangle)((Object)arrayList3)).y < n + n11) {
                        graphics2D.drawString(gene3.getLocusTag(), ((Rectangle)((Object)arrayList3)).x, ((Rectangle)((Object)arrayList3)).y + n18);
                    }
                } else if (((Rectangle)((Object)arrayList3)).y >= n + n6) {
                    graphics2D.drawString(gene3.getLocusTag(), ((Rectangle)((Object)arrayList3)).x, ((Rectangle)((Object)arrayList3)).y + n18);
                }
                ((ViewData)object22).setNameRect((Rectangle)((Object)arrayList3));
                if (n12 == 1) {
                    if (gene3.getDirection() == 1) {
                        ((ViewData)object22).setEffective(((Rectangle)((Object)arrayList3)).y >= n + n6);
                    } else {
                        ((ViewData)object22).setEffective(((Rectangle)((Object)arrayList3)).y < n + n11);
                    }
                } else if (gene3.getDirection() == 1) {
                    ((ViewData)object22).setEffective(((Rectangle)((Object)arrayList3)).y < n + n11);
                } else {
                    ((ViewData)object22).setEffective(((Rectangle)((Object)arrayList3)).y >= n + n6);
                }
            }
            this.m_viewDataList.add(object22);
            if (!this.rgmCondition.isPatternColor() || geneClass == null) continue;
            arrayList3 = geneClass.getDomainList().iterator();
            while (arrayList3.hasNext()) {
                Domain domain = (Domain)arrayList3.next();
                list = (List)this.m_dupMap.get(String.valueOf(domain.getClusterId()));
                if (list == null) {
                    list = new ArrayList<DupData>();
                    this.m_dupMap.put(String.valueOf(domain.getClusterId()), list);
                }
                double d9 = n12 == 1 ? (double)(domain.getFrom() - n9) * d2 + 5.0 : (double)(n10 - domain.getTo()) * d2 + 5.0;
                double d10 = (double)(domain.getTo() - domain.getFrom() + 1) * d2;
                DupData dupData = new DupData();
                dupData.setDataRect2D(((ViewData)object22).getDataRect2D());
                dupData.setDomainRect2D(this.createSimpleGeneShape(d9, d, d10, d5));
                dupData.setDrawShape((Shape)object);
                list.add(dupData);
            }
        }
        arrayList2.clear();
        arrayList2 = null;
        graphics2D.setColor(this.getImageBackgroundColor(n2));
        graphics2D.fillRect(0, n, 5, n11);
        graphics2D.fillRect(this.m_image.getWidth() - 5, n, 5, n11);
        this.drawChromosomeLine(graphics2D, n14);
        return true;
    }

    private Color getNotIncludeClusterGeneColor(String string) {
        Color color = Color.white;
        if (this.rgmCondition.isFuncCatColor()) {
            color = FunctionColorUtil.getFuncCatColor("-1");
        } else if (this.rgmCondition.isPPMColor()) {
            color = ColorFacade.getInstance().getBlankColor(string);
        }
        return color;
    }

    private Color getGeneColor(Organism organism, Domain domain) {
        Color color = null;
        color = this.rgmCondition.isFuncCatColor() ? domain.getFuncCatColor(this.m_clusterTbl, organism.getOrganismCode()) : (this.rgmCondition.isPPMColor() ? ColorFacade.getInstance().getPrimaryColor(domain.getCluser(), organism, domain.getLocusTag()) : (Color)this.mediator.getClusterIdColor(domain.getClusterId()));
        return color;
    }

    private void drawChromosomeLine(Graphics2D graphics2D, int n) {
        double d = (double)(this.m_image.getWidth() - 10) / 5.0;
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(5, n + 1, this.m_image.getWidth() - 5, n + 1);
        for (int i = 0; i <= 5; ++i) {
            double d2 = (double)i * d + 5.0;
            graphics2D.drawLine((int)d2, n, (int)d2, n + 3);
        }
    }

    private int getImageFontHeight() {
        return this.getFontMetrics(IMAGE_FONT).getHeight();
    }

    private int getImageFontAscent() {
        return this.getFontMetrics(IMAGE_FONT).getAscent();
    }

    private int getTitleFontHeight() {
        return this.getFontMetrics(TITLE_FONT).getHeight();
    }

    private int getTitleFontAscent() {
        return this.getFontMetrics(TITLE_FONT).getAscent();
    }

    private Color getImageBackgroundColor(int n) {
        return n % 2 == 0 ? BACKGROUND_COLOR1 : BACKGROUND_COLOR2;
    }

    private Shape createGeneShape(int n, Gene gene, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (gene.isJoin()) {
            List list = gene.getExonRegionList();
            float f = 4.0f;
            float f2 = (float)d2;
            float f3 = (float)(d2 + d4);
            float f4 = f2 + f;
            float f5 = f3 - f;
            Stack<Point2D.Float> stack = new Stack<Point2D.Float>();
            GeneralPath generalPath = new GeneralPath();
            float f6 = -2.1474836E9f;
            for (Range range : list) {
                float f7 = (float)this.calcX(n, range.getX1(), d5, d6, d7);
                float f8 = (float)this.calcX(n, range.getX2(), d5, d6, d7);
                if (f6 == -2.1474836E9f) {
                    generalPath.moveTo(f7, f2);
                    stack.push(new Point2D.Float(f7, f3));
                } else {
                    generalPath.lineTo(f7, f4);
                    generalPath.lineTo(f7, f2);
                    stack.push(new Point2D.Float(f7, f5));
                    stack.push(new Point2D.Float(f7, f3));
                }
                generalPath.lineTo(f8, f2);
                generalPath.lineTo(f8, f4);
                stack.push(new Point2D.Float(f8, f3));
                stack.push(new Point2D.Float(f8, f5));
                f6 = f8;
            }
            int n2 = stack.size();
            for (int i = 0; i < n2; ++i) {
                Point2D.Float float_ = (Point2D.Float)stack.pop();
                generalPath.lineTo(float_.x, float_.y);
            }
            generalPath.closePath();
            return generalPath;
        }
        return this.createSimpleGeneShape(d, d2, d3, d4);
    }

    private Rectangle2D createSimpleGeneShape(double d, double d2, double d3, double d4) {
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    private double calcX(int n, double d, double d2, double d3, double d4) {
        double d5 = n == 1 ? (d - d2) * d4 + 5.0 : (d3 - d) * d4 + 5.0;
        return d5;
    }

    private double getGeneStartY(int n, int n2, double d, double d2) {
        double d3 = n == 1 ? (n2 == 1 ? d : d2) : (n2 == 1 ? d2 : d);
        return d3;
    }

    private Color getCentralGeneColor(Organism organism, int n, Domain domain, int n2) {
        Color color = Color.black;
        color = n == domain.getNo() ? Color.red : this.getGeneColor(organism, domain);
        return color;
    }

    private void drawDup(Graphics2D graphics2D, List list, Color color, Color color2, int n, boolean bl) {
        Shape shape = graphics2D.getClip();
        for (DupData dupData : list) {
            Rectangle2D.Double double_ = (Rectangle2D.Double)dupData.getDataRect2D();
            Rectangle2D.Double double_2 = (Rectangle2D.Double)dupData.getDomainRect2D();
            Shape shape2 = dupData.getDrawShape();
            graphics2D.setClip(shape2);
            if (bl) {
                graphics2D.setColor(color);
                graphics2D.fill(double_2);
            } else {
                graphics2D.setColor(color2);
                graphics2D.fill(double_2);
                graphics2D.setColor(color);
                switch (n) {
                    case 1: {
                        double d = double_2.width / 3.0;
                        double d2 = double_2.x + d;
                        double d3 = double_2.height / 3.0;
                        double d4 = double_2.y + d3;
                        graphics2D.fill(new Rectangle2D.Double(d2, double_2.y, d, double_2.height));
                        graphics2D.fill(new Rectangle2D.Double(double_2.x, d4, double_2.width, d3));
                        break;
                    }
                    case 2: {
                        double d3 = double_2.height / 3.0;
                        double d4 = double_2.y + d3;
                        graphics2D.fill(new Rectangle2D.Double(double_2.x, d4, double_2.width, d3));
                        break;
                    }
                    case 3: {
                        Polygon polygon = new Polygon();
                        polygon.addPoint((int)double_2.x, (int)double_2.y);
                        polygon.addPoint((int)double_2.x, (int)(double_2.y + double_2.height));
                        polygon.addPoint((int)(double_2.x + double_2.width), (int)double_2.y);
                        graphics2D.fill(polygon);
                        break;
                    }
                    case 4: {
                        Polygon polygon = new Polygon();
                        polygon.addPoint((int)double_2.x, (int)double_2.y);
                        polygon.addPoint((int)(double_2.x + double_2.width), (int)double_2.y);
                        polygon.addPoint((int)(double_2.x + double_2.width), (int)(double_2.y + double_2.height));
                        graphics2D.fill(polygon);
                        break;
                    }
                    case 5: {
                        Polygon polygon = new Polygon();
                        polygon.addPoint((int)(double_2.x + double_2.width / 2.0), (int)double_2.y);
                        polygon.addPoint((int)double_2.x, (int)(double_2.y + double_2.height / 2.0));
                        polygon.addPoint((int)(double_2.x + double_2.width / 2.0), (int)(double_2.y + double_2.height));
                        polygon.addPoint((int)(double_2.x + double_2.width), (int)(double_2.y + double_2.height / 2.0));
                        graphics2D.fill(polygon);
                        break;
                    }
                    case 6: {
                        Polygon polygon = new Polygon();
                        double d = double_2.width / 3.0;
                        polygon.addPoint((int)double_2.x, (int)double_2.y);
                        polygon.addPoint((int)double_2.x, (int)(double_2.y + double_2.height));
                        polygon.addPoint((int)(double_2.x + d), (int)double_2.y);
                        graphics2D.fill(polygon);
                        polygon.reset();
                        polygon.addPoint((int)(double_2.x + double_2.width), (int)double_2.y);
                        polygon.addPoint((int)(double_2.x + double_2.width - d), (int)(double_2.y + double_2.height));
                        polygon.addPoint((int)(double_2.x + double_2.width), (int)(double_2.y + double_2.height));
                        graphics2D.fill(polygon);
                        break;
                    }
                    default: {
                        Polygon polygon = new Polygon();
                        double d = double_2.width / 3.0;
                        polygon.addPoint((int)double_2.x, (int)double_2.y);
                        polygon.addPoint((int)double_2.x, (int)(double_2.y + double_2.height));
                        polygon.addPoint((int)(double_2.x + d), (int)(double_2.y + double_2.height));
                        graphics2D.fill(polygon);
                        polygon.reset();
                        polygon.addPoint((int)(double_2.x + double_2.width - d), (int)double_2.y);
                        polygon.addPoint((int)(double_2.x + double_2.width), (int)(double_2.y + double_2.height));
                        polygon.addPoint((int)(double_2.x + double_2.width), (int)double_2.y);
                        graphics2D.fill(polygon);
                    }
                }
            }
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
        }
        graphics2D.setClip(shape);
    }

    void setClusterTbl(ClusterTbl clusterTbl) {
        this.m_clusterTbl = clusterTbl;
    }

    void setGeneInfoC(Collection collection) {
        this.organismLocusTagMap = GeneInfoUtil.createOrganismCodeLocusTagListMap(collection);
    }

    private boolean isExistGene() {
        return !MapUtil.isNull(this.organismLocusTagMap);
    }

    private int getDataHeight() {
        int n = this.getTitleFontHeight();
        n += 13;
        n += 3;
        n += 13;
        int n2 = this.getImageFontHeight();
        n = this.rgmCondition.isShowLabel() ? (n += n2 * 10) : (n += n2 * 2);
        return n;
    }

    void setProgressImpl(ProgressImpl progressImpl) {
        this.m_progressImpl = progressImpl;
    }

    int getViewCount() {
        if (!this.isExistGene()) {
            return 0;
        }
        int n = 0;
        for (List list : this.organismLocusTagMap.values()) {
            if (CollectionUtil.isNull(list)) continue;
            n += list.size();
        }
        return n;
    }

    private ChromosomeTbl getChromosomeTbl(String string) {
        ChromosomeTbl chromosomeTbl = (ChromosomeTbl)this.m_chromosomeTblMap.get(string);
        if (chromosomeTbl == null) {
            try {
                chromosomeTbl = new ChromosomeTbl(string);
                chromosomeTbl.read();
                this.m_chromosomeTblMap.put(string, chromosomeTbl);
            }
            catch (Exception exception) {
                chromosomeTbl = null;
                logger.warn("Fail to read chromosome file. " + string, exception);
            }
        }
        return chromosomeTbl;
    }

    private GeneTbl getGeneTbl(String string) {
        GeneTbl geneTbl = (GeneTbl)this.m_geneTblMap.get(string);
        if (geneTbl == null) {
            try {
                geneTbl = new GeneTbl(string);
                geneTbl.read();
                this.m_geneTblMap.put(string, geneTbl);
            }
            catch (Exception exception) {
                geneTbl = null;
                logger.warn("Fail to read gene file. " + string, exception);
            }
        }
        return geneTbl;
    }

    private void initImage(int n, int n2) {
        if (this.m_image == null || n != this.m_image.getWidth() || n2 != this.m_image.getHeight()) {
            if (this.m_image != null) {
                this.m_image.flush();
                this.m_image = null;
            }
            this.m_image = new BufferedImage(n, n2, 1);
        }
    }

    private Graphics2D getGraphics2D() {
        Graphics2D graphics2D = (Graphics2D)this.m_image.getGraphics();
        graphics2D.setFont(IMAGE_FONT);
        return graphics2D;
    }

    void createAlignmentMap(Dimension dimension) {
        int n = this.getViewCount();
        int n2 = dimension.width;
        int n3 = this.getDataHeight();
        int n4 = n3 * n;
        if (n4 < dimension.height) {
            n4 = dimension.height;
        } else {
            n2 -= this.m_sbW;
        }
        this.initImage(n2, n4);
        Graphics2D graphics2D = this.getGraphics2D();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.m_image.getWidth(), this.m_image.getHeight());
        if (this.m_dupMap != null) {
            for (ArrayList arrayList : this.m_dupMap.values()) {
                arrayList.clear();
                arrayList = null;
            }
            this.m_dupMap.clear();
            this.m_dupMap = null;
        }
        this.m_viewDataList.clear();
        if (this.m_clusterTbl == null) {
            return;
        }
        if (this.rgmCondition.isPatternColor()) {
            this.m_dupMap = new HashMap();
        }
        int n5 = 0;
        int n6 = 0;
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object : this.m_clusterTbl.getViewOrganismList()) {
            GeneTbl geneTbl;
            ChromosomeTbl chromosomeTbl;
            String string = ((Organism)object).getOrganismCode();
            List list = (List)this.organismLocusTagMap.get(string);
            if (list == null || (chromosomeTbl = this.getChromosomeTbl(string)) == null || (geneTbl = this.getGeneTbl(string)) == null) continue;
            for (Object object2 : list) {
                if (hashSet.contains(object2)) continue;
                if (this.draw(graphics2D, (Organism)object, chromosomeTbl, geneTbl, (String)object2, n6, n5)) {
                    n6 += n3;
                    ++n5;
                } else {
                    logger.info((String)object2 + " was not found.");
                }
                hashSet.add(object2);
            }
            if (this.m_progressImpl != null) {
                this.m_progressImpl.increment();
            }
            hashMap.put(string, "OK");
            hashMap2.put(string, "OK");
        }
        if (this.rgmCondition.isPatternColor()) {
            Object object;
            Iterator<Object> iterator = new ArrayList();
            object = this.m_dupMap.values().iterator();
            while (object.hasNext()) {
                iterator.add((List)object.next());
            }
            Collections.sort(iterator, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((List)object2).size() - ((List)object).size();
                }
            });
            object = PatternTbl.getInstance();
            int n7 = 0;
            int n8 = 0;
            int n9 = 1;
            int n10 = 0;
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                Object object2;
                object2 = (List)iterator2.next();
                if (object2.size() == 1) continue;
                Color color = n10 == 0 ? Color.green : ((PatternColor)((ArrayList)object).get(n7)).getForeground();
                Color color2 = n10 == 0 ? Color.green : ((PatternColor)((ArrayList)object).get(n8)).getBackground();
                this.drawDup(graphics2D, (List)object2, color, color2, n9, ++n10 <= 5);
                if (n10 == 1) continue;
                if (++n7 == ((ArrayList)object).size()) {
                    n7 = 0;
                    ++n8;
                }
                if (n8 == ((ArrayList)object).size()) {
                    n8 = 0;
                }
                if (n10 < 6 || ++n9 != 8) continue;
                n9 = 1;
            }
        }
        for (Object object : hashMap.keySet()) {
            hashMap.put(object, (String)this.m_geneTblMap.remove(object));
            hashMap2.put(object, (String)this.m_chromosomeTblMap.remove(object));
        }
        for (Object object : this.m_geneTblMap.values()) {
            ((HashMap)object).clear();
            object = null;
        }
        this.m_geneTblMap.clear();
        this.m_geneTblMap.putAll(hashMap);
        for (Object object : this.m_chromosomeTblMap.values()) {
            ((TreeMap)object).clear();
            object = null;
        }
        this.m_chromosomeTblMap.clear();
        this.m_chromosomeTblMap.putAll(hashMap2);
        hashMap.clear();
        hashMap2.clear();
        hashMap = null;
        hashMap2 = null;
        this.setPreferredSize(new Dimension(n2, n6));
        this.revalidate();
        this.repaint();
        graphics2D.dispose();
    }

    void createGeneClassMap() {
        this.m_geneClassMap = new HashMap();
        if (this.m_clusterTbl == null) {
            return;
        }
        Iterator iterator = this.m_clusterTbl.getClusterList().iterator();
        while (iterator.hasNext()) {
            if (this.m_progressImpl != null && this.m_progressImpl.isCanceled()) {
                this.clearGeneClassMap();
                return;
            }
            Cluster cluster = (Cluster)iterator.next();
            for (String string : cluster.getSpSet()) {
                for (String string2 : cluster.getLocusTagList(string)) {
                    Object object;
                    Object object2;
                    Object object3;
                    if (GeneUtil.isDomain(string2)) {
                        object3 = GeneUtil.removeDomainNo(string2);
                        object2 = (GeneClass)this.m_geneClassMap.get(object3);
                        if (object2 == null) {
                            object2 = new GeneClass();
                            this.m_geneClassMap.put(object3, object2);
                        }
                        ((GeneClass)object2).setOrganism(string);
                        object = cluster.getGeneInformation(string, string2);
                        Domain domain = new Domain(cluster, (GeneInformation)object);
                        ((GeneClass)object2).addDomain(domain);
                        continue;
                    }
                    object3 = new GeneClass();
                    ((GeneClass)object3).setOrganism(string);
                    object2 = cluster.getGeneInformation(string, string2);
                    object = new Domain(cluster, (GeneInformation)object2);
                    ((GeneClass)object3).addDomain((Domain)object);
                    this.m_geneClassMap.put(string2, object3);
                }
            }
            if (this.m_progressImpl == null) continue;
            this.m_progressImpl.increment();
        }
    }

    void clearGeneClassMap() {
        if (this.m_image != null) {
            this.m_image.flush();
            this.m_image = null;
        }
        if (this.m_geneClassMap != null) {
            Iterator iterator = this.m_geneClassMap.values().iterator();
            while (iterator.hasNext()) {
                ((GeneClass)iterator.next()).clear();
            }
            this.m_geneClassMap.clear();
            this.m_geneClassMap = null;
        }
        if (this.m_dupMap != null) {
            for (Cloneable cloneable : this.m_dupMap.values()) {
                cloneable.clear();
                cloneable = null;
            }
            this.m_dupMap.clear();
            this.m_dupMap = null;
        }
        for (Cloneable cloneable : this.m_geneTblMap.values()) {
            ((HashMap)cloneable).clear();
            cloneable = null;
        }
        this.m_geneTblMap.clear();
        for (Cloneable cloneable : this.m_chromosomeTblMap.values()) {
            ((TreeMap)cloneable).clear();
            cloneable = null;
        }
        this.m_chromosomeTblMap.clear();
        System.gc();
    }

    private void showPopup(Gene gene, Point point) {
        String string;
        String string2 = gene.getOrganism();
        List list = GeneUrlFacade.createUrlMenuList(this, this.mediator, this.m_clusterTbl, string2, string = gene.getLocusTag());
        if (!CollectionUtil.isNull(list)) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jPopupMenu.add((JMenuItem)iterator.next());
            }
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    private void showPopup2(Point point) {
        int n = this.rgmCondition.getZoomRange();
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (int i = 0; i < VIEW_RANGE_ITEMS.length; ++i) {
            boolean bl = VIEW_RANGE_ITEMS[i] == n;
            List list = GeneInfoUtil.createGeneInfoList(this.organismLocusTagMap);
            jPopupMenu.add(new ViewRangeItem(this, this.mediator, VIEW_RANGE_ITEMS[i], bl, list, this.rgmCondition));
        }
        jPopupMenu.show(this, point.x, point.y);
    }

    private boolean setGenePosition(Gene gene, GeneClass geneClass) {
        if (geneClass.isGetData()) {
            return true;
        }
        geneClass.setGetData(true);
        List list = geneClass.getDomainList();
        for (Domain domain : list) {
            if (gene.isPositive()) {
                domain.setFrom(domain.getFrom() + gene.getStart());
                domain.setTo(domain.getTo() + gene.getStart() - 1);
                continue;
            }
            int n = domain.getFrom();
            domain.setFrom(gene.getLength() - domain.getTo() + gene.getStart());
            domain.setTo(gene.getLength() - n + gene.getStart() - 1);
        }
        return true;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.m_image != null) {
            graphics.drawImage(this.m_image, 0, 0, null);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Gene gene;
        if (mouseEvent.getClickCount() == 2 && (gene = this.getGene(mouseEvent.getPoint())) != null) {
            String string = GeneUrlFacade.getDefaultUrl(this.m_clusterTbl, gene.getOrganism(), gene.getLocusTagWithDomainNo());
            this.mediator.viewUrl(string);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    private Gene getGene(Point point) {
        for (ViewData viewData : this.m_viewDataList) {
            if ((!viewData.isEffective() || viewData.getNameRect() == null || !viewData.getNameRect().contains(point)) && !viewData.getDataRect2D().contains(point.getX(), point.getY())) continue;
            return (Gene)viewData.getObject();
        }
        return null;
    }

    private void showPopupMenu(Point point) {
        Gene gene = this.getGene(point);
        if (gene != null) {
            this.showPopup(gene, point);
            return;
        }
        if (this.isExistGene()) {
            this.showPopup2(point);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    void zoomIn() {
        int n = this.rgmCondition.getZoomRange();
        if (n == VIEW_RANGE_ITEMS[0]) {
            return;
        }
        for (int i = 0; i < VIEW_RANGE_ITEMS.length; ++i) {
            if (VIEW_RANGE_ITEMS[i] != n) continue;
            this.mediator.changeViewRange(VIEW_RANGE_ITEMS[i - 1], this.rgmCondition, null);
            break;
        }
    }

    void zoomOut() {
        int n = this.rgmCondition.getZoomRange();
        if (n == VIEW_RANGE_ITEMS[VIEW_RANGE_ITEMS.length - 1]) {
            return;
        }
        for (int i = 0; i < VIEW_RANGE_ITEMS.length; ++i) {
            if (VIEW_RANGE_ITEMS[i] != n) continue;
            this.mediator.changeViewRange(VIEW_RANGE_ITEMS[i + 1], this.rgmCondition, null);
            break;
        }
    }

    void labelOnOff(boolean bl) {
        try {
            this.rgmCondition.setShowLabel(bl);
            ApplicationPropertyFacade.saveProperty(this.rgmCondition.getDomClustId(), this.rgmCondition);
        }
        catch (IOException iOException) {
            String string = "Fail to save regional genome map information. DomClust ID" + this.rgmCondition.getDomClustId() + " showLabel = " + bl;
            logger.warn(string, iOException);
        }
        this.mediator.drawFeatureMap2();
    }

    void clear() {
        this.organismLocusTagMap.clear();
        this.clearGeneClassMap();
    }
}

