/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.observer;

import cgdp.recog.observer.ApplicationObserverEvent;
import cgdp.recog.util.ApplicationLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class ApplicationObservable
extends Observable {
    private static final ApplicationLogger logger = new ApplicationLogger(ApplicationObservable.class);
    private List observerList = new ArrayList();
    private boolean async = true;

    public synchronized void addObserver(Observer observer) {
        if (!this.observerList.contains(observer)) {
            this.observerList.add(observer);
        }
    }

    public synchronized void deleteObserver(Observer observer) {
        this.observerList.remove(observer);
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(final ApplicationObserverEvent applicationObserverEvent) {
        Object[] objectArray;
        this.setChanged();
        ApplicationObservable applicationObservable = this;
        synchronized (applicationObservable) {
            objectArray = this.observerList.toArray();
            this.clearChanged();
        }
        if (this.async) {
            for (int i = objectArray.length - 1; i >= 0; --i) {
                final Observer observer = (Observer)objectArray[i];
                if (applicationObserverEvent.getSource() == observer) continue;
                Runnable runnable = new Runnable(){

                    public void run() {
                        observer.update(ApplicationObservable.this, applicationObserverEvent);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        } else {
            for (int i = objectArray.length - 1; i >= 0; --i) {
                Observer observer = (Observer)objectArray[i];
                if (applicationObserverEvent.getSource() == observer) continue;
                try {
                    observer.update(this, applicationObserverEvent);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    logger.warn("Runtime Exception:", runtimeException);
                }
            }
        }
    }

    public synchronized int countObservers() {
        return this.observerList.size();
    }

    public void setAsync(boolean bl) {
        this.async = bl;
    }
}

