/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.organism.OrganismSet;
import cgdp.recog.organism.OrganismSetGroup;
import cgdp.recog.organism.OrganismTableModel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.OverwriteAddOptionPanel;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class OrganismSetDialog
extends AbstractApplyDialog {
    private static final ApplicationLogger logger = new ApplicationLogger(OrganismSetDialog.class);
    private static final String TITLE = "Organism Set";
    private FocusTextField nameTextField;
    private JComboBox organismSetConboBox;
    private JLabel optionTitleLabel;
    private OverwriteAddOptionPanel optionPanel;
    private JPanel listPanel;
    private JTable organismTable;
    private JButton deleteButton;
    private OrganismSet targetOrganismSet;
    private List allOrganismSetList = new ArrayList();

    public OrganismSetDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField(30);
        this.organismSetConboBox = new JComboBox();
        this.organismSetConboBox.setVisible(false);
        this.optionTitleLabel = new JLabel("Target");
        this.optionPanel = new OverwriteAddOptionPanel(){

            protected void processNew() {
                OrganismSetDialog.this.setVisibleNameField();
            }

            protected void processAdd() {
                OrganismSetDialog.this.setVisibleNameField();
            }

            protected void processOverwrite() {
                OrganismSetDialog.this.setVisibleNameField();
            }
        };
        this.listPanel = this.createListPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(15, 15, 15, 5), 0, 0));
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.organismSetConboBox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.optionTitleLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 15, 5), 0, 0));
        this.getContentPane().add((Component)this.optionPanel, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 15, 15), 0, 0));
        this.getContentPane().add((Component)this.listPanel, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 10, 5), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createListPanel() {
        OrganismTableModel organismTableModel = new OrganismTableModel();
        this.organismTable = new JTable(organismTableModel);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.organismTable, 20, 30);
        jScrollPane.getViewport().setPreferredSize(new Dimension(300, 150));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private OrganismTableModel getOrganismTableModel() {
        return (OrganismTableModel)this.organismTable.getModel();
    }

    public void updateValue(String string) {
        String string2 = this.createOrganismSetName();
        this.nameTextField.setText(string2);
        this.optionTitleLabel.setVisible(true);
        this.optionPanel.setVisible(true);
        this.setAllOrganismSetList(string);
        this.updateOrganismSetItem();
        this.setVisibleNameField();
        this.setVisibleOrganismList(false);
        this.pack();
    }

    public void updateValue(OrganismSet organismSet, String string) {
        this.targetOrganismSet = organismSet;
        String string2 = organismSet.getName();
        this.nameTextField.setText(string2);
        this.optionTitleLabel.setVisible(false);
        this.optionPanel.setVisible(false);
        this.optionPanel.setNew();
        this.setAllOrganismSetList(string);
        this.updateOrganismSetItem();
        this.setVisibleNameField();
        this.setVisibleOrganismList(true);
        this.updateOrganismList(organismSet);
        this.pack();
    }

    private void setAllOrganismSetList(String string) {
        try {
            this.allOrganismSetList = OrganismSetGroup.importOrganismSetList(string);
        }
        catch (Exception exception) {
            logger.warn("Fail to load cluster set. " + string, exception);
        }
    }

    private Set createAllClusterSetNameSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (OrganismSet organismSet : this.allOrganismSetList) {
            hashSet.add(organismSet.getName());
        }
        return hashSet;
    }

    private String createOrganismSetName() {
        String string;
        Set set = this.createAllClusterSetNameSet();
        int n = 1;
        String string2 = "Organism Set ";
        while (set.contains(string = string2 + n)) {
            ++n;
        }
        return string;
    }

    private void setVisibleNameField() {
        this.nameTextField.setVisible(this.optionPanel.isNew());
        this.organismSetConboBox.setVisible(!this.optionPanel.isNew());
    }

    private void setVisibleOrganismList(boolean bl) {
        this.listPanel.setVisible(bl);
    }

    private void updateOrganismList(OrganismSet organismSet) {
        List list = organismSet.getOrganismList();
        OrganismTableModel organismTableModel = this.getOrganismTableModel();
        organismTableModel.setOrganismList(list);
    }

    private void updateOrganismSetItem() {
        this.organismSetConboBox.removeAllItems();
        OrganismSetGroup organismSetGroup = OrganismSetGroup.getInstance();
        for (OrganismSet organismSet : organismSetGroup.getOrganismSetList()) {
            this.organismSetConboBox.addItem(organismSet.getName());
        }
    }

    public String getOrganismSetName() {
        if (this.isNew()) {
            return this.getOrganismSetNameNew();
        }
        return this.getOrganismSetNameOther();
    }

    public List getOrganismList() {
        return this.getOrganismTableModel().getOrganismList();
    }

    private String getOrganismSetNameNew() {
        return this.nameTextField.getText();
    }

    private String getOrganismSetNameOther() {
        return (String)this.organismSetConboBox.getSelectedItem();
    }

    public boolean isNew() {
        return this.optionPanel.isNew();
    }

    public boolean isOverwrite() {
        return this.optionPanel.isOverwrite();
    }

    public boolean isAdd() {
        return this.optionPanel.isAdd();
    }

    protected boolean check() {
        Set set;
        if (StringTool.isNull(this.getOrganismSetName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        if (this.isNew() && (set = this.createAllClusterSetNameSet()).contains(this.getOrganismSetNameNew()) && (this.targetOrganismSet == null || this.targetOrganismSet != null && !this.targetOrganismSet.equalsName(this.getOrganismSetNameNew()))) {
            String[] stringArray = new String[]{"You have already made organism set [" + this.getOrganismSetName() + "].", "Input the another name."};
            MessageManager.showErrorMessage((Component)this, stringArray);
            return false;
        }
        return super.check();
    }

    protected boolean apply() {
        return true;
    }

    private void delete() {
        int[] nArray = this.organismTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.getOrganismTableModel().remove(nArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        }
    }
}

