/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismSet;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class OrganismSetImporter
extends FileImporter {
    private static final String TITLE_ORGANISM_SET = "OrganismSet";
    private static final String PREFIX_NAME = "#NAME";
    private static final String DELIMITER_PARAM = "\t";
    private static final String DELIMITER_SP = ",";
    private static final String DELIMITER_ORGANISM = "//";
    private String filepath;
    private List organismSetList = new ArrayList();
    private OrganismSet organismSet;

    public OrganismSetImporter(String string) {
        this.filepath = string;
        this.setExistHeader(false);
    }

    protected String getFilepath() {
        return this.filepath;
    }

    protected void parseDataLine(int n, String string) {
        if (string.equals(TITLE_ORGANISM_SET)) {
            this.organismSet = new OrganismSet();
        } else if (string.startsWith(PREFIX_NAME)) {
            String string2 = this.getValue(PREFIX_NAME, string);
            this.organismSet.setName(string2);
        } else if (string.equals(DELIMITER_ORGANISM)) {
            this.organismSetList.add(this.organismSet);
        } else {
            List list = this.getOrganismList(string);
            this.organismSet.setOrganismList(list);
        }
    }

    private String getValue(String string, String string2) {
        return string2.substring(string.length() + 1);
    }

    private List getOrganismList(String string) {
        Vector vector = StringTool.splitString(string, DELIMITER_SP);
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        for (String string2 : vector) {
            Organism organism = ModifiedOrganismManager.getInstance().getModifiedOrganism(string2);
            if (organism != null) {
                arrayList.add(organism);
                continue;
            }
            arrayList.add(OrganismUtil.getOrganism(string2));
        }
        return arrayList;
    }

    protected void parseHeaderLine(String string) {
    }

    public List getOrganismSetList() {
        return this.organismSetList;
    }
}

