/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.patch;

import cgdp.recog.data.DataManager;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.patch.AbstractPatch;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.url.GeneUrl;
import cgdp.recog.url.GeneUrlFacade;
import cgdp.recog.util.ApplicationLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GeneUrlFilePatch
extends AbstractPatch {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneUrlFilePatch.class);
    private static final String GENE_URL_SCRIPT_NAME = "RECOG_gene_info_frame";

    public String getPatchReleaseDateString() {
        return "2009/6/2";
    }

    public void execute() {
        try {
            OptionTbl optionTbl = OptionTbl.getInstance();
            OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
            optionValues.setGeneAnnotationUrl("/htbin/RECOG/RECOG_gene_info_frame.pl?spec=#1&name=#2&tabid=#3");
            optionTbl.writeOption();
            List list = ProjectAccesser.loadProject();
            for (Project project : list) {
                String string = DataManager.getProjectGeneUrlFilepath(project);
                if (!new File(string).isFile()) continue;
                boolean bl = false;
                List list2 = GeneUrlFacade.getGeneUrlList(project);
                ArrayList<GeneUrl> arrayList = new ArrayList<GeneUrl>();
                for (GeneUrl geneUrl : list2) {
                    if (GeneUrlFilePatch.isOldMBGDGeneAnnoationUrl(geneUrl)) {
                        GeneUrl geneUrl2 = GeneUrlFacade.createGeneAnnotationUrl();
                        geneUrl2.setDef(geneUrl.isDef());
                        arrayList.add(geneUrl2);
                    } else {
                        arrayList.add(geneUrl);
                    }
                    if (!GeneUrlFilePatch.isMBGDClusterAnnoationUrl(geneUrl)) continue;
                    bl = true;
                }
                if (!bl) {
                    arrayList.add(GeneUrlFacade.createClusterAnnotationUrl());
                }
                GeneUrlFacade.saveGeneUrlList(string, arrayList);
            }
        }
        catch (Exception exception) {
            String string = "Fail to patch gene url.";
            logger.warn(string, exception);
        }
    }

    private static boolean isOldMBGDGeneAnnoationUrl(GeneUrl geneUrl) {
        if (geneUrl.getUrlTemplate().indexOf(GENE_URL_SCRIPT_NAME) == -1) {
            return false;
        }
        return geneUrl.getUrlTemplate().indexOf("#exec_dclst_url") == -1;
    }

    private static boolean isMBGDClusterAnnoationUrl(GeneUrl geneUrl) {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        return geneUrl.getUrlTemplate().indexOf(optionValues.getClusterAnnotationUrl()) != -1;
    }
}

