/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.pattern;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Pattern
implements Cloneable {
    private String name;
    private Map organismCodeValueMap = new HashMap();
    private Map organismCodeIgnoreMap = new HashMap();

    public Pattern() {
    }

    public Pattern(Collection collection, Set set) {
        this.updateOrganismCodeValueMap(collection, set);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Set getOrganismCodeSet() {
        return this.getOrganismCodeValueMap().keySet();
    }

    public List getOrganismCodeList() {
        ArrayList arrayList = new ArrayList(this.getOrganismCodeValueMap().keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public List getOrganismCodeListWithoutIgnore() {
        List list = this.getOrganismCodeList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (this.isIgnore(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public int getOrganismSize() {
        return this.getOrganismCodeValueMap().size();
    }

    public boolean containsOrganism(String string) {
        return this.getOrganismCodeValueMap().containsKey(string);
    }

    public boolean containsAllOrganism(Set set) {
        return this.getOrganismCodeValueMap().keySet().containsAll(set);
    }

    public void setValue(String string, double d) {
        this.organismCodeValueMap.put(string, new Float(d));
    }

    public double getValue(String string) {
        Float f = (Float)this.getOrganismCodeValueMap().get(string);
        if (f == null) {
            return 0.0;
        }
        return f.doubleValue();
    }

    public void setIgnore(String string, boolean bl) {
        this.getOrganismCodeIgnoreMap().put(string, new Boolean(bl));
    }

    public boolean isIgnore(String string) {
        Boolean bl = (Boolean)this.getOrganismCodeIgnoreMap().get(string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public Set getIgnoreOrganismCodeSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.getOrganismCodeIgnoreMap().keySet()) {
            if (!this.isIgnore(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void addOrganism(String string, double d, boolean bl) {
        this.organismCodeValueMap.put(string, new Float(d));
        this.organismCodeIgnoreMap.put(string, new Boolean(bl));
    }

    private Map getOrganismCodeValueMap() {
        return this.organismCodeValueMap;
    }

    private void setOrganismCodeValueMap(Map map) {
        this.organismCodeValueMap = map;
    }

    private Map getOrganismCodeIgnoreMap() {
        return this.organismCodeIgnoreMap;
    }

    private void setOrganismCodeIgnoreMap(Map map) {
        this.organismCodeIgnoreMap = map;
    }

    private void updateOrganismCodeValueMap(Collection collection, Set set) {
        this.organismCodeValueMap.clear();
        for (String string : collection) {
            Float f = new Float(0.0);
            if (set.contains(string)) {
                f = new Float(1.0);
            }
            this.organismCodeValueMap.put(string, f);
            this.organismCodeIgnoreMap.put(string, Boolean.FALSE);
        }
    }

    public boolean equalsName(Pattern pattern) {
        return this.getName().equals(pattern.getName());
    }

    public boolean equalsPattern(Pattern pattern) {
        return this.getName().equals(pattern.getName()) && this.getOrganismCodeValueMap().equals(pattern.getOrganismCodeValueMap());
    }

    public String getPatternString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.getOrganismCodeList()) {
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(this.getValue(string));
            stringBuffer.append(":");
            stringBuffer.append(this.isIgnore(string));
            stringBuffer.append("\t");
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        Pattern pattern = new Pattern();
        pattern.setName(this.getName());
        pattern.setOrganismCodeValueMap(new HashMap(this.getOrganismCodeValueMap()));
        pattern.setOrganismCodeIgnoreMap(new HashMap(this.getOrganismCodeIgnoreMap()));
        return pattern;
    }
}

