/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomeImporter;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.DomClustFileUtil;
import cgdp.recog.domclust.DomClustQuery;
import cgdp.recog.filefilter.FileExtension;
import cgdp.recog.project.FileTableModel;
import cgdp.recog.project.FilterComboBoxModel;
import cgdp.recog.project.FilterComboBoxRenderer;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.project.ProjectComboBoxModel;
import cgdp.recog.project.ProjectComboBoxRenderer;
import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.system.property.ApplicationPropertyVirtualFile;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.AlignmentTableCellRenderer;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileSizeComparator;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.ReadOnlyTextArea;
import cgdp.recog.util.StringTool;
import cgdp.recog.util.TableSorter;
import cgdp.recog.util.TextFieldDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;

public class DeleteDialog
extends JDialog
implements ItemListener,
ActionListener,
MouseListener,
KeyListener {
    private static final ApplicationLogger logger = new ApplicationLogger(DeleteDialog.class);
    private static DeleteDialog DELETE_DIALOG;
    private static final String TITLE = "File Manager";
    private static final Dimension DIALOG_SIZE;
    private MediatorImpl mediator;
    private JComboBox projectComboBox;
    private JTable fileTable;
    private ReadOnlyTextArea propertyArea;
    private JComboBox filterComboBox;
    private JPanel buttonPanel;
    private JButton renameButton;
    private JButton deleteButton;
    private JButton closeButton;

    private DeleteDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createDeleteDialog(Frame frame, MediatorImpl mediatorImpl) {
        DELETE_DIALOG = new DeleteDialog(frame, mediatorImpl);
    }

    public static DeleteDialog getInstance() {
        return DELETE_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createProjectPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.createFileTablePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.createFilterComboBox(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.createButtonPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.initValue();
        this.setSize(DIALOG_SIZE);
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createProjectPanel() {
        JLabel jLabel = new JLabel("Project");
        ProjectComboBoxModel projectComboBoxModel = new ProjectComboBoxModel();
        this.projectComboBox = new JComboBox(projectComboBoxModel);
        this.projectComboBox.setRenderer(new ProjectComboBoxRenderer());
        this.projectComboBox.addItemListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.projectComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        return jPanel;
    }

    private JPanel createFileTablePanel() {
        FileTableModel fileTableModel = new FileTableModel();
        TableSorter tableSorter = new TableSorter(fileTableModel){

            protected Comparator getComparator(int n) {
                if (n == 1) {
                    return new FileSizeComparator();
                }
                return super.getComparator(n);
            }
        };
        this.fileTable = new JTable(tableSorter);
        tableSorter.setTableHeader(this.fileTable.getTableHeader());
        this.fileTable.setRowHeight(20);
        this.fileTable.addMouseListener(this);
        this.fileTable.setShowHorizontalLines(false);
        this.fileTable.setShowVerticalLines(false);
        this.fileTable.setAutoResizeMode(0);
        this.fileTable.addKeyListener(this);
        TableColumn tableColumn = this.fileTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(180);
        TableColumn tableColumn2 = this.fileTable.getColumnModel().getColumn(1);
        tableColumn2.setCellRenderer(new AlignmentTableCellRenderer(4));
        tableColumn2.setPreferredWidth(70);
        TableColumn tableColumn3 = this.fileTable.getColumnModel().getColumn(2);
        tableColumn3.setPreferredWidth(120);
        this.fileTable.getSelectionModel().setSelectionMode(0);
        this.fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    File file = DeleteDialog.this.getSelectedFile();
                    DeleteDialog.this.updatePropertyPanel(file);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.fileTable, 20, 30);
        this.propertyArea = new ReadOnlyTextArea();
        this.propertyArea.setLineWrap(true);
        this.propertyArea.setColumns(50);
        JScrollPane jScrollPane2 = new JScrollPane(this.propertyArea, 20, 31);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 2.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jScrollPane2, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createButtonPanel() {
        this.renameButton = new JButton("Rename");
        this.renameButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.closeButton);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeleteDialog.this.closeButton.doClick();
            }
        };
        this.closeButton.getInputMap(2).put(KeyStroke.getKeyStroke('\u001b'), "Cancel");
        this.closeButton.getActionMap().put("Cancel", abstractAction);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.renameButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.deleteButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.closeButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return this.buttonPanel;
    }

    private JComboBox createFilterComboBox() {
        FilterComboBoxModel filterComboBoxModel = new FilterComboBoxModel();
        this.filterComboBox = new JComboBox(filterComboBoxModel);
        this.filterComboBox.setRenderer(new FilterComboBoxRenderer());
        this.filterComboBox.addItemListener(this);
        return this.filterComboBox;
    }

    public void updateValue() {
        int n;
        Object object;
        ItemListener[] itemListenerArray;
        Project project = ProjectAccesser.getSelectedProject();
        this.updateProjectList();
        if (project != null) {
            itemListenerArray = this.removeItemListenersFromProjectComboBox();
            object = this.getValidProjectFromComboBox(project);
            this.projectComboBox.setSelectedItem(object);
            this.addItemListenersToProjectComboBox(itemListenerArray);
        }
        itemListenerArray = this.getSelectedFile();
        this.updateFileList();
        if (itemListenerArray != null && (n = ((FileTableModel)(object = this.getFileTableModel())).indexOfFile((File)itemListenerArray)) != -1) {
            int n2 = this.getTableSorter().viewIndex(n);
            this.fileTable.setRowSelectionInterval(n, n2);
        }
    }

    private FileTableModel getFileTableModel() {
        return (FileTableModel)((TableSorter)this.fileTable.getModel()).getTableModel();
    }

    private List getProjectList() {
        List list = ProjectAccesser.loadProject();
        return list;
    }

    private void initValue() {
        this.updateProjectList();
        Project project = ProjectAccesser.getSelectedProject();
        this.projectComboBox.setSelectedItem(this.getValidProjectFromComboBox(project));
        this.updateFileList();
    }

    private Project getValidProjectFromComboBox(Project project) {
        Project project2 = null;
        for (int i = 0; i < this.projectComboBox.getItemCount(); ++i) {
            Project project3 = (Project)this.projectComboBox.getItemAt(i);
            if (!project3.equalsProject(project)) continue;
            project2 = project3;
            break;
        }
        if (project2 == null && this.projectComboBox.getItemCount() != 0) {
            project2 = (Project)this.projectComboBox.getItemAt(0);
        }
        return project2;
    }

    private ItemListener[] removeItemListenersFromProjectComboBox() {
        ItemListener[] itemListenerArray = this.projectComboBox.getItemListeners();
        if (itemListenerArray == null) {
            return null;
        }
        for (int i = 0; i < itemListenerArray.length; ++i) {
            this.projectComboBox.removeItemListener(itemListenerArray[i]);
        }
        return itemListenerArray;
    }

    private void addItemListenersToProjectComboBox(ItemListener[] itemListenerArray) {
        if (itemListenerArray == null) {
            return;
        }
        for (int i = 0; i < itemListenerArray.length; ++i) {
            this.projectComboBox.addItemListener(itemListenerArray[i]);
        }
    }

    private void updateProjectList() {
        ItemListener[] itemListenerArray = this.removeItemListenersFromProjectComboBox();
        this.projectComboBox.removeAllItems();
        for (Project project : this.getProjectList()) {
            this.projectComboBox.addItem(project);
        }
        this.addItemListenersToProjectComboBox(itemListenerArray);
    }

    private void updateFileList() {
        Project project = (Project)this.projectComboBox.getSelectedItem();
        if (project == null) {
            return;
        }
        File file = new File(project.getDirectoryPath());
        List list = this.getFileList(project, file);
        FileFilter fileFilter = (FileFilter)this.filterComboBox.getSelectedItem();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : list) {
            if (!fileFilter.accept(file2)) continue;
            arrayList.add(file2);
        }
        FileTableModel fileTableModel = this.getFileTableModel();
        fileTableModel.setFileList(arrayList);
    }

    private List getFileList(Project project, File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!file.isDirectory()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(fileArray[i]);
        }
        Map map = ApplicationPropertyFacade.getConfDirnameMap(project);
        for (String string : map.keySet()) {
            ApplicationPropertyConf applicationPropertyConf = (ApplicationPropertyConf)map.get(string);
            String string2 = ApplicationPropertyFacade.getApplicationPropertyDirpath(project, applicationPropertyConf);
            if (!new File(string2).isDirectory()) continue;
            File file2 = DomClustFileUtil.findDomClustFileByViewId(applicationPropertyConf.getDomClustViewId(), project);
            String string3 = new File(file, applicationPropertyConf.getConfName() + ".dclst").getAbsolutePath();
            ApplicationPropertyVirtualFile applicationPropertyVirtualFile = new ApplicationPropertyVirtualFile(string3, file2, applicationPropertyConf);
            arrayList.add(applicationPropertyVirtualFile);
        }
        return arrayList;
    }

    private void updatePropertyPanel(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        if (FileExtension.isDomClustFile(file)) {
            if (file instanceof ApplicationPropertyVirtualFile) {
                stringBuffer.append(this.getDomClustProperties((ApplicationPropertyVirtualFile)file));
            } else {
                stringBuffer.append(this.getDomClustProperties(file));
            }
        } else if (FileExtension.isCoreGenomeFile(file)) {
            stringBuffer.append(this.getCoreGenomeProperties(file));
        }
        this.propertyArea.setText(stringBuffer.toString());
        this.propertyArea.repaint();
        this.propertyArea.setCaretPosition(0);
    }

    private String getDomClustProperties(ApplicationPropertyVirtualFile applicationPropertyVirtualFile) {
        try {
            ApplicationPropertyConf applicationPropertyConf = applicationPropertyVirtualFile.getConf();
            File file = applicationPropertyVirtualFile.getRealFile();
            AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(file.getAbsolutePath());
            abstractDomClustImporter.setParameterOnly(true);
            abstractDomClustImporter.execute();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cluster ID:");
            stringBuffer.append(abstractDomClustImporter.getDomClustId());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Comment:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(StringTool.displayNewLine2NewLine(applicationPropertyConf.getComment()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Cluster Count:");
            stringBuffer.append(abstractDomClustImporter.getNClusters());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Server:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + abstractDomClustImporter.getServerUrl());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            String string = DomClustQuery.createDisplayOptions(abstractDomClustImporter.getDomClustConditionString());
            stringBuffer.append("Options:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(string);
            ArrayList arrayList = new ArrayList(abstractDomClustImporter.getIngroupOrganismCodeList());
            Collections.sort(arrayList);
            stringBuffer.append("Ingroup(");
            stringBuffer.append(arrayList.size());
            stringBuffer.append("):");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + StringTool.conbineStrList(arrayList, ","));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            ArrayList arrayList2 = new ArrayList(abstractDomClustImporter.getOutgroupOrganismCodeList());
            Collections.sort(arrayList2);
            stringBuffer.append("Outgroup(");
            stringBuffer.append(arrayList2.size());
            stringBuffer.append("):");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + StringTool.conbineStrList(arrayList2, ","));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Created by:");
            stringBuffer.append(applicationPropertyConf.getCreateUser());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Created on:");
            stringBuffer.append(applicationPropertyConf.getCreateDate());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Updated by:");
            stringBuffer.append(applicationPropertyConf.getUpdateUser());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Updated on:");
            stringBuffer.append(applicationPropertyConf.getUpdateDate());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            logger.warn("Fail to get domclust properties.", iOException);
            return "";
        }
    }

    private String getDomClustProperties(File file) {
        try {
            AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(file.getAbsolutePath());
            abstractDomClustImporter.setParameterOnly(true);
            abstractDomClustImporter.execute();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cluster ID:");
            stringBuffer.append(abstractDomClustImporter.getDomClustId());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Cluster Count:");
            stringBuffer.append(abstractDomClustImporter.getNClusters());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Server:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + abstractDomClustImporter.getServerUrl());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            String string = DomClustQuery.createDisplayOptions(abstractDomClustImporter.getDomClustConditionString());
            stringBuffer.append("Options:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(string);
            ArrayList arrayList = new ArrayList(abstractDomClustImporter.getIngroupOrganismCodeList());
            Collections.sort(arrayList);
            stringBuffer.append("Ingroup(");
            stringBuffer.append(arrayList.size());
            stringBuffer.append("):");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + StringTool.conbineStrList(arrayList, ","));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            ArrayList arrayList2 = new ArrayList(abstractDomClustImporter.getOutgroupOrganismCodeList());
            Collections.sort(arrayList2);
            stringBuffer.append("Outgroup(");
            stringBuffer.append(arrayList2.size());
            stringBuffer.append("):");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + StringTool.conbineStrList(arrayList2, ","));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            logger.warn("Fail to get domclust properties.", iOException);
            return "";
        }
    }

    private String getCoreGenomeProperties(File file) {
        try {
            CoreGenomeImporter coreGenomeImporter = new CoreGenomeImporter(file.getAbsolutePath());
            coreGenomeImporter.setParameterOnly(true);
            coreGenomeImporter.execute();
            GenomeAlign genomeAlign = coreGenomeImporter.getGenomeAlign();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cluster ID:");
            stringBuffer.append(genomeAlign.getDomClustId());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Core Tab ID:");
            stringBuffer.append(genomeAlign.getCoreGenomeId());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Reference Genome:");
            stringBuffer.append(coreGenomeImporter.getReferenceOrganismCode());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Species:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(StringTool.conbineStrList(genomeAlign.getOrganismCodeList(), ","));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append("Server:");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(" " + coreGenomeImporter.getServerUrl());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            logger.warn("Fail to get core genome properties.", iOException);
            return "";
        }
    }

    public Project getSelectedProject() {
        return (Project)this.projectComboBox.getSelectedItem();
    }

    public File getSelectedFile() {
        int n = this.fileTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        FileTableModel fileTableModel = this.getFileTableModel();
        return fileTableModel.getFile(this.getTableSorter().modelIndex(n));
    }

    private TableSorter getTableSorter() {
        return (TableSorter)this.fileTable.getModel();
    }

    protected boolean check() {
        if (this.fileTable.getSelectedRow() == -1) {
            MessageManager.showErrorMessage((Component)this, "Select file.");
            return false;
        }
        return true;
    }

    private void close() {
        this.exit();
    }

    protected void exit() {
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.deleteButton) {
            try {
                File file = this.getSelectedFile();
                this.delete();
                this.updateFileList();
                String string = file.getName() + " was deleted.";
                MessageManager.showMessage((Component)this, string);
            }
            catch (Exception exception) {
                logger.info("Abandon deleting file. ");
                if (exception.getMessage().length() > 0) {
                    String string = "delete was not completed. " + exception.getMessage();
                    MessageManager.showErrorMessage((Component)this, string);
                }
            }
        } else if (actionEvent.getSource() == this.renameButton) {
            try {
                File file = this.getSelectedFile();
                String string = this.rename();
                this.updateFileList();
                String string2 = file.getName() + " was renamed to " + string;
                MessageManager.showMessage((Component)this, string2);
            }
            catch (Exception exception) {
                logger.info("Abandon renaming file. ");
                if (exception.getMessage().length() > 0) {
                    String string = "rename was not completed. " + exception.getMessage();
                    MessageManager.showErrorMessage((Component)this, string);
                }
            }
        } else if (actionEvent.getSource() == this.closeButton) {
            this.close();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.projectComboBox) {
            this.updateFileList();
        } else if (itemEvent.getSource() == this.filterComboBox) {
            this.updateFileList();
        }
    }

    private String rename() throws Exception {
        Window window = null;
        try {
            File file = this.getSelectedFile();
            if (file == null) {
                throw new Exception("No file is selected.");
            }
            if (this.mediator.isOpenedDomClust((Project)this.projectComboBox.getSelectedItem(), file)) {
                throw new Exception(file.getName() + " is currently edited.");
            }
            String string = FileUtil.getExtension(file.getName());
            window = new TextFieldDialog((Dialog)this, this.mediator, "rename", FileUtil.removeExtension(file.getName()));
            ((Dialog)window).setVisible(true);
            if (((AbstractApplyDialog)window).isCanceled()) {
                throw new Exception("");
            }
            String string2 = ((TextFieldDialog)window).getText();
            if (string2 == null || string2.length() <= 0) {
                throw new Exception("Please input a new name.");
            }
            string2 = string2 + "." + string;
            this.rename(file, string2);
            String string3 = string2;
            return string3;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (window != null) {
                window.dispose();
                window = null;
            }
        }
    }

    private void rename(File file, String string) throws Exception {
        Project project = (Project)this.projectComboBox.getSelectedItem();
        if (project == null) {
            throw new Exception("No project is opened.");
        }
        File file2 = new File(project.getDirectoryPath() + string);
        if (file.getName().compareTo(file2.getName()) == 0) {
            throw new Exception("");
        }
        if (file2.exists()) {
            throw new Exception(file2.getName() + " already exists.");
        }
        if (FileExtension.isDomClustFile(file)) {
            project.renameDomClustFile(file, file2);
        } else if (FileExtension.isCoreGenomeFile(file)) {
            project.renameCoalnFile(file, file2);
        } else {
            throw new Exception("Unacceptable extension " + file2.getName());
        }
    }

    private void delete() throws Exception {
        Project project = (Project)this.projectComboBox.getSelectedItem();
        if (project == null) {
            throw new Exception("No project is opened.");
        }
        File file = this.getSelectedFile();
        if (file == null) {
            throw new Exception("No file is selected.");
        }
        file = new File(project.getDirectoryPath() + file.getName());
        String string = "Is it OK to delete " + file.getName() + "?";
        if (!MessageManager.showConfirmMessage((Component)this, string)) {
            throw new Exception("");
        }
        if (this.mediator.isOpenedDomClust(project, file)) {
            throw new Exception(file.getName() + " is on editing.");
        }
        if (FileExtension.isDomClustFile(file)) {
            project.deleteDomClustFile(file);
        } else if (FileExtension.isCoreGenomeFile(file)) {
            project.deleteCoalnFile(file);
        } else {
            throw new Exception("Unknown extension " + file.getName());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.renameButton.doClick();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127) {
            this.deleteButton.doClick();
        } else if (keyEvent.getKeyCode() == 10) {
            this.renameButton.doClick();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    static {
        DIALOG_SIZE = new Dimension(600, 400);
    }
}

