/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.project.ProjectUtil;
import cgdp.recog.server.Server;
import cgdp.recog.server.ServerComboBox;
import cgdp.recog.server.ServerTbl;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.DirectoryFileFilter;
import cgdp.recog.util.FileSelectPanel;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProjectEditDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Project Setting";
    private MediatorImpl mediator;
    private Project project;
    private List projectList;
    private FocusTextField nameTextField;
    private FileSelectPanel rootDirectoryFileSelectPanel;
    private ServerComboBox serverUrlComboBox;
    private JButton serverSelectButton;

    public ProjectEditDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.project = Project.createClientProject();
        this.projectList = ProjectAccesser.loadProject();
        this.createComponents();
        this.updateTitle(true);
    }

    public ProjectEditDialog(Frame frame, MediatorImpl mediatorImpl, Project project) {
        super(frame);
        this.mediator = mediatorImpl;
        this.project = project;
        this.projectList = ProjectAccesser.loadProject();
        this.createComponents();
        this.updateTitle(false);
    }

    public ProjectEditDialog(Dialog dialog, MediatorImpl mediatorImpl, Project project, List list, boolean bl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.project = project;
        this.projectList = list;
        this.createComponents();
        this.updateTitle(bl);
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        this.nameTextField.setColumns(40);
        JLabel jLabel2 = new JLabel("Root Directory");
        this.rootDirectoryFileSelectPanel = new FileSelectPanel(new DirectoryFileFilter());
        this.rootDirectoryFileSelectPanel.setFileSelectionMode(1);
        JLabel jLabel3 = new JLabel("Server URL");
        JPanel jPanel = this.createServerSelectPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.updateValue();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateTitle(boolean bl) {
        if (bl) {
            this.setTitle("New Project");
        } else {
            this.setTitle("Edit Project");
        }
    }

    private JPanel createServerSelectPanel() {
        this.serverUrlComboBox = new ServerComboBox();
        this.serverSelectButton = new JButton("New Server...");
        this.serverSelectButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.serverUrlComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.serverSelectButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void updateValue() {
        this.nameTextField.setText(this.project.getProjectName());
        if (StringTool.isNull(this.project.getDirectoryPath())) {
            this.rootDirectoryFileSelectPanel.setDefaultPath(ProjectUtil.getDefaultRootProjectDirpath());
        } else {
            this.rootDirectoryFileSelectPanel.setDefaultPath(this.project.getRootDirectoryPath());
        }
        this.updateServerUrlComboBox(this.project.getServerUrl());
    }

    private void updateServerUrlComboBox(String string) {
        this.serverUrlComboBox.updateServerItem();
        this.serverUrlComboBox.setSelectedItem(string);
    }

    public Project getProject() {
        return this.project;
    }

    public Project getModifiedProject() {
        this.project.setProjectName(this.getProjectName());
        this.project.setDirectoryPath(this.getDirectoryPath());
        this.project.setServerUrl(this.getServerUrl());
        return this.project;
    }

    protected boolean check() {
        if (StringTool.isNull(this.getProjectName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        if (this.isDuplicateProject()) {
            MessageManager.showErrorMessage((Component)this, "Duplicate name.");
            return false;
        }
        if (StringTool.isNull(this.getDirectoryPath())) {
            MessageManager.showErrorMessage((Component)this, "Input Root directory path.");
            return false;
        }
        if (StringTool.isNull(this.getServerUrl())) {
            MessageManager.showErrorMessage((Component)this, "Input server URL.");
            return false;
        }
        return true;
    }

    private boolean isDuplicateProject() {
        for (Project project : this.projectList) {
            if (this.project.equalsProject(project) || !project.equalsName(this.nameTextField.getText())) continue;
            return true;
        }
        return false;
    }

    String getProjectName() {
        return this.nameTextField.getText();
    }

    String getDirectoryPath() {
        return new File(this.rootDirectoryFileSelectPanel.getPath(), this.nameTextField.getText()).getAbsolutePath();
    }

    String getServerUrl() {
        return (String)this.serverUrlComboBox.getSelectedItem();
    }

    protected boolean apply() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.serverSelectButton) {
            this.selectServer();
        }
    }

    private void selectServer() {
        ServerTbl serverTbl = ServerTbl.getInstance();
        serverTbl.updateSelectState(this.getServerUrl());
        Server server = this.mediator.showNewServerDialog();
        if (server != null) {
            this.updateServerUrlComboBox(server.getUrl());
        }
    }
}

