/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.propvect;

import cgdp.recog.propvect.CalcDistancePhyloPat;
import cgdp.recog.propvect.PhyloPat;

class CalcHammingDistancePhyloPat
extends CalcDistancePhyloPat {
    static double[][] McutCache;

    CalcHammingDistancePhyloPat(int n, double d) {
        super(n);
        CalcHammingDistancePhyloPat.calcCache(n, d);
    }

    double calc(PhyloPat phyloPat, PhyloPat phyloPat2) throws RuntimeException {
        int n;
        int n2 = phyloPat.count();
        if (McutCache[n2][n = phyloPat2.count()] > (double)Math.min(n2, n)) {
            return Double.MAX_VALUE;
        }
        int n3 = phyloPat.countMatch(phyloPat2);
        double d = (double)(n2 + n - 2 * n3) / (double)this.length;
        return d;
    }

    static void calcCache(int n, double d) {
        McutCache = new double[n + 1][n + 1];
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n; ++j) {
                CalcHammingDistancePhyloPat.McutCache[i][j] = ((double)(i + j) - d * (double)n) / 2.0;
            }
        }
    }
}

