/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.propvect;

import cgdp.recog.propvect.NumVect;

public class PhyloPat
extends NumVect {
    int[] vect;
    int length;
    String name;
    int count = -1;

    public PhyloPat(int n) {
        this.vect = new int[n];
        this.length = n;
    }

    public PhyloPat(int n, String string) {
        this(n);
        this.name = string;
    }

    public void set(int n, int n2) {
        this.vect[n] = n2;
    }

    public void set(int n, String string) {
        this.vect[n] = Integer.valueOf(string);
    }

    public double get(int n) {
        return this.vect[n];
    }

    public String getName() {
        return this.name;
    }

    public int compareTo(Object object) {
        PhyloPat phyloPat = (PhyloPat)object;
        for (int i = 0; i < this.length; ++i) {
            int n = (int)this.get(i) - (int)phyloPat.get(i);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    double sum() {
        return this.count();
    }

    int count() {
        if (this.count < 0) {
            this.count = 0;
            for (int i = 0; i < this.length; ++i) {
                this.count += this.vect[i];
            }
        }
        return this.count;
    }

    int countMatch(PhyloPat phyloPat) throws RuntimeException {
        int n = 0;
        if (phyloPat.length() != this.length) {
            throw new RuntimeException("data length mismatch");
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.vect[i] != 1 || this.vect[i] != phyloPat.vect[i]) continue;
            ++n;
        }
        return n;
    }

    public int length() {
        return this.vect.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name + ":");
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(String.valueOf(this.vect[i]));
        }
        return stringBuffer.toString();
    }
}

