/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.propvect;

import cgdp.recog.hcluster.HClustException;
import cgdp.recog.propvect.CalcCorrelationPhyloPat;
import cgdp.recog.propvect.CalcDistance;
import cgdp.recog.propvect.CalcDistancePhyloPat;
import cgdp.recog.propvect.CalcHammingDistancePhyloPat;
import cgdp.recog.propvect.CalcHyperGeometricProbPhyloPat;
import cgdp.recog.propvect.CalcMutInformationPhyloPat;
import cgdp.recog.propvect.CompressedPhyloPatArray;
import cgdp.recog.propvect.NumVectArray;
import cgdp.recog.propvect.PhyloPat;
import cgdp.recog.propvect.PropVect;

public class PhyloPatArray
extends NumVectArray {
    PropVect createNewElement(String string) {
        return new PhyloPat(this.colnum, string);
    }

    CalcDistance createCalcDistance(int n, double d) {
        CalcDistancePhyloPat calcDistancePhyloPat;
        switch (n) {
            default: {
                calcDistancePhyloPat = new CalcCorrelationPhyloPat(this.colnum, d, false);
                break;
            }
            case 1: {
                calcDistancePhyloPat = new CalcCorrelationPhyloPat(this.colnum, d, true);
                break;
            }
            case 2: {
                calcDistancePhyloPat = new CalcHammingDistancePhyloPat(this.colnum, d);
                break;
            }
            case 3: {
                calcDistancePhyloPat = new CalcMutInformationPhyloPat(this.colnum, d);
                break;
            }
            case 4: {
                calcDistancePhyloPat = new CalcHyperGeometricProbPhyloPat(this.colnum, d);
            }
        }
        return calcDistancePhyloPat;
    }

    CalcDistance createCalcProbability(double d) {
        return new CalcHyperGeometricProbPhyloPat(this.colnum, d);
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        int n = Integer.valueOf(stringArray[1]);
        double d = Double.valueOf(stringArray[2]);
        double d2 = 2.0;
        if (stringArray.length >= 4) {
            Double.valueOf(stringArray[3]);
        }
        PhyloPatArray phyloPatArray = null;
        try {
            phyloPatArray = new PhyloPatArray();
            phyloPatArray.readFromFile(string);
            if (phyloPatArray == null) {
                System.err.println("Can't read file: " + string);
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println("Can't open file: " + string);
            System.exit(1);
        }
        phyloPatArray = new CompressedPhyloPatArray(phyloPatArray);
        try {
            phyloPatArray.compareAll(n, d, d2);
        }
        catch (HClustException hClustException) {
            System.err.println("Can't compareAll: " + string);
            System.exit(1);
        }
    }
}

