/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.Node;
import cgdp.recog.ptree.bean.Plotter;
import cgdp.recog.ptree.bean.TextShape;
import cgdp.recog.ptree.bean.Tree;
import cgdp.recog.ptree.bean.Utils;
import cgdp.recog.ptree.bean.data.PPoint;
import cgdp.recog.ptree.bean.dgGraphics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class NodeLabel
extends TextShape {
    protected Node m_node;
    protected Tree m_tree;
    protected double m_angle;
    protected int m_dist;
    protected boolean m_isNeverdrawn = true;
    protected boolean m_isNeedRectToPolar;
    protected Plotter m_plotter;
    protected Point m_origin = new Point(0, 0);
    protected dgGraphics m_dg;

    public NodeLabel(String string, Tree tree, Node node, int n, double d) {
        super(string);
        if (string != null) {
            int n2 = string.indexOf(35);
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
            this.m_text = string;
        }
        this.m_tree = tree;
        this.m_node = node;
        this.m_angle = d;
        this.m_dist = n;
        if (this.m_dist == 0) {
            this.m_dist = 4;
        }
    }

    public String getText() {
        return this.m_text;
    }

    public Node getNode() {
        return this.m_node;
    }

    public void setGraphics(Graphics graphics) {
        super.setGraphics(graphics);
        if (this.m_plotter == null) {
            this.m_plotter = new Plotter(this.m_g, this.m_dg);
        }
        this.setExtent();
    }

    public void setGraphics(Plotter plotter) {
        this.setGraphics(plotter.getGraphics());
        this.m_dg = plotter.getDgGraphics();
        Rectangle rectangle = this.m_dg.getBounds();
        this.m_dg.set(plotter.getDgGraphics());
        this.m_dg.setBounds(rectangle);
        this.setExtent();
    }

    protected void setOrigin(int n, int n2) {
        this.m_origin.x = this.m_dg.offsetX() + n;
        this.m_origin.y = this.m_dg.offsetY() + n2;
    }

    protected void setPosition() {
        if (this.m_isNeedRectToPolar) {
            this.rectToPolar();
        }
        this.setOrigin(this.m_node.getH(), this.m_node.getV());
        this.m_plotter.setPosition(this.m_origin.x, this.m_origin.y);
        if (Utils.isMissing(this.m_angle)) {
            this.m_angle = 0.0;
        }
        this.m_plotter.setHeading(this.m_angle);
        this.m_plotter.penUp();
        this.m_plotter.forward(this.m_dist);
        PPoint pPoint = new PPoint();
        this.m_plotter.getPlotter(pPoint);
        this.m_rect.x = pPoint.x;
        this.m_rect.y = pPoint.y;
    }

    protected void setStyle() {
        this.setExtent();
    }

    public void pinShape(Tree tree, Plotter plotter) {
        this.m_tree = tree;
        this.setGraphics(plotter);
        if (this.m_isNeverdrawn) {
            this.m_rect.x = this.m_node.getH();
            this.m_rect.y = this.m_node.getV();
        }
        this.setPosition();
    }

    public void updateBounds() {
        super.updateBounds();
        this.m_isNeedRectToPolar = true;
    }

    protected void rectToPolar() {
        this.setOrigin(this.m_node.getH(), this.m_node.getV());
        double d = this.m_rect.x - this.m_origin.x;
        double d2 = this.m_rect.y - this.m_origin.y;
        this.m_dist = (int)Math.round(Math.sqrt(d * d + d2 * d2));
        this.m_angle = Plotter.headFromPt(d, d2);
        this.m_isNeedRectToPolar = false;
    }

    public void drawShape() {
        if (!this.m_tree.isVisible(this.m_node)) {
            return;
        }
        if (this.m_isNeverdrawn) {
            this.m_isNeedRectToPolar = false;
            this.m_isNeverdrawn = false;
            this.setStyle();
            this.setPosition();
        }
        super.drawShape();
    }
}

