/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.search.ClusterTreeNode;
import cgdp.recog.search.GeneTreeNode;
import cgdp.recog.search.KeywordSearchResult;
import cgdp.recog.util.treetable.AbstractTreeTableModel;
import cgdp.recog.util.treetable.TreeTableModel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class GeneSearchTreeTableModel
extends AbstractTreeTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"", "Name", "Gene Name", "Organism", "Description"};
    private static final Class[] COLUMN_TYPES = new Class[]{Boolean.class, TreeTableModel.class, String.class, String.class, String.class, String.class};

    public GeneSearchTreeTableModel() {
    }

    public GeneSearchTreeTableModel(Object object) {
        super(object);
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    public Class getColumnClass(int n) {
        return COLUMN_TYPES[n];
    }

    public boolean isCellEditable(Object object, int n) {
        if (n == 0) {
            return true;
        }
        return super.isCellEditable(object, n);
    }

    public Object getValueAt(Object object, int n) {
        if (object instanceof ClusterTreeNode) {
            Cluster cluster = ((ClusterTreeNode)object).getCluster();
            switch (n) {
                case 0: {
                    return new Boolean(((ClusterTreeNode)object).isSelected());
                }
                case 1: {
                    return cluster.getDisplayClusterId();
                }
                case 2: {
                    return cluster.getGeneName();
                }
                case 4: {
                    if (cluster.getDescription() == null) {
                        return "";
                    }
                    return cluster.getDescription();
                }
            }
            return "";
        }
        if (object instanceof GeneTreeNode) {
            GeneTreeNode geneTreeNode = (GeneTreeNode)object;
            GeneInformation geneInformation = ((GeneTreeNode)object).getGeneInformation();
            switch (n) {
                case 0: {
                    return new Boolean(geneTreeNode.isSelected());
                }
                case 1: {
                    return geneInformation.getLocusTag();
                }
                case 2: {
                    return geneTreeNode.getGeneName();
                }
                case 3: {
                    return geneTreeNode.getOrganismCode();
                }
                case 4: {
                    if (geneTreeNode.getDescription() == null) {
                        return "";
                    }
                    return geneTreeNode.getDescription();
                }
            }
            return "";
        }
        return null;
    }

    public void setValueAt(Object object, Object object2, int n) {
        if (n == 0) {
            if (object2 instanceof ClusterTreeNode) {
                ClusterTreeNode clusterTreeNode = (ClusterTreeNode)object2;
                clusterTreeNode.setSelected((Boolean)object);
                Enumeration<TreeNode> enumeration = clusterTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    this.fireTreeNodesChanged(defaultMutableTreeNode);
                }
            } else if (object2 instanceof GeneTreeNode) {
                GeneTreeNode geneTreeNode = (GeneTreeNode)object2;
                geneTreeNode.setSelected((Boolean)object);
                TreeNode treeNode = geneTreeNode.getParent();
                if (treeNode != null) {
                    this.fireTreeNodesChanged(treeNode);
                }
            }
        }
    }

    public Object getChild(Object object, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        return defaultMutableTreeNode.getChildAt(n);
    }

    public int getChildCount(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        return defaultMutableTreeNode.getChildCount();
    }

    public List getSelectedSearchResultList() {
        ArrayList<KeywordSearchResult> arrayList = new ArrayList<KeywordSearchResult>();
        TreeNode treeNode = (TreeNode)this.getRoot();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            ClusterTreeNode clusterTreeNode;
            TreeNode treeNode2 = enumeration.nextElement();
            if (!(treeNode2 instanceof ClusterTreeNode) || !(clusterTreeNode = (ClusterTreeNode)treeNode2).isSelected()) continue;
            Enumeration<? extends TreeNode> enumeration2 = treeNode2.children();
            while (enumeration2.hasMoreElements()) {
                GeneTreeNode geneTreeNode;
                TreeNode treeNode3 = enumeration2.nextElement();
                if (!(treeNode3 instanceof GeneTreeNode) || !(geneTreeNode = (GeneTreeNode)treeNode3).isSelected()) continue;
                KeywordSearchResult keywordSearchResult = geneTreeNode.getSearchResult();
                arrayList.add(keywordSearchResult);
            }
        }
        return arrayList;
    }
}

