/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.seq;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.seq.SeqDownloadCondition;
import cgdp.recog.seq.SeqDownloader;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.ProgressTask;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class SeqDownloadExecuter
extends AbstractThreadProcess {
    private static final String PREFIX_HEADER = ">";
    private static final int PROGRESS_DEGREE = 3;
    private static final int MAX_PROGRESS = 90;
    private static final int PROGRESS_UPDATE_INTERVAL = 2000;
    private static final ApplicationLogger logger = new ApplicationLogger(SeqDownloadExecuter.class);
    private SeqDownloadCondition condition;

    public SeqDownloadExecuter(SeqDownloadCondition seqDownloadCondition) {
        this.condition = seqDownloadCondition;
    }

    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(100);
        ProgressTask progressTask = new ProgressTask(progressImpl, 3, 90);
        progressTask.setMaxProgress(90);
        Timer timer = new Timer();
        timer.schedule((TimerTask)progressTask, 0L, 2000L);
        SeqDownloader seqDownloader = null;
        try {
            seqDownloader = new SeqDownloader(this.condition);
            seqDownloader.execute();
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
            return;
        }
        if (seqDownloader.isError()) {
            this.setError(true);
            this.setErrorMessage(seqDownloader.getMessage());
            return;
        }
        try {
            String string = this.condition.isEachGene() ? this.addClusterId(seqDownloader.getContents()) : seqDownloader.getContents();
            progressImpl.increment();
            FileUtil.outputFile(string, this.condition.getOutputFilepath());
            progressImpl.setCount(99);
            progressImpl.increment();
        }
        catch (Exception exception) {
            String string = "Fail to download the sequence file.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addClusterId(String string) throws IOException {
        StringReader stringReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            stringReader = new StringReader(string);
            bufferedReader = new BufferedReader(stringReader);
            String string3 = null;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf("<HTML>") != -1 || string3.indexOf("<PRE>") != -1 || string3.indexOf("</PRE>") != -1 || string3.indexOf("</HTML>") != -1) continue;
                if (string3.startsWith(PREFIX_HEADER)) {
                    String string4;
                    string2 = string3.substring(1);
                    Vector vector = StringTool.splitString(string2, " ");
                    String string5 = (String)vector.get(0);
                    Vector vector2 = StringTool.splitString(string5, ":");
                    String string6 = ((String)vector2.get(0)).trim();
                    List list = ClusterUtil.findCluster(string6, string4 = ((String)vector2.get(1)).trim(), this.condition.getClusterC());
                    if (!CollectionUtil.isNull(list)) {
                        Cluster cluster = (Cluster)list.get(0);
                        stringBuffer.append(PREFIX_HEADER + string6 + ":" + string4 + " [cluster " + cluster.getCombinedClusterIdRegardSubCluster() + "]");
                    } else {
                        stringBuffer.append(PREFIX_HEADER + string6 + ":" + string4);
                    }
                } else {
                    stringBuffer.append(string3);
                }
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                ++n;
            }
            string2 = stringBuffer.toString();
            return string2;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (stringReader != null) {
                stringReader.close();
            }
        }
    }

    public void done() {
        if (this.isError()) {
            MessageManager.showErrorMessage(null, this.getErrorMessages());
        }
    }
}

