/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.server;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.AccessServer;
import cgdp.recog.server.Server;
import cgdp.recog.server.ServerComparator;
import cgdp.recog.server.ServerListItem;
import cgdp.recog.server.ServerTbl;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ServerChangeMenu
extends JMenu
implements MenuListener,
ActionListener {
    private MediatorImpl mediator;

    public ServerChangeMenu(MediatorImpl mediatorImpl) {
        super("Change Server");
        this.addMenuListener(this);
        this.mediator = mediatorImpl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof CommandImpl) {
            ((CommandImpl)actionEvent.getSource()).execute();
        }
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
        this.removeAll();
    }

    public void menuSelected(MenuEvent menuEvent) {
        Project project = ProjectAccesser.getSelectedProject();
        ServerTbl serverTbl = ServerTbl.getInstance();
        ArrayList arrayList = new ArrayList(serverTbl);
        Collections.sort(arrayList, new ServerComparator(project.getServerUrl()));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Server server : arrayList) {
            ServerMenuItem serverMenuItem = new ServerMenuItem(this.mediator, server);
            this.add(serverMenuItem);
            buttonGroup.add(serverMenuItem);
            serverMenuItem.addActionListener(this);
            serverMenuItem.setSelected(server.equalsServer(AccessServer.getInstance().getServerUrl()));
            serverMenuItem.setEnabled(!this.mediator.isExistDomClustResult());
        }
        this.addSeparator();
        this.add(new ServerListItem(this, this.mediator));
    }

    private class ServerMenuItem
    extends JRadioButtonMenuItem
    implements CommandImpl {
        private MediatorImpl mediator;
        private Server server;

        public ServerMenuItem(MediatorImpl mediatorImpl, Server server) {
            super(server.getUrl());
            this.mediator = mediatorImpl;
            this.server = server;
        }

        public void execute() {
            this.mediator.changeSelectServer(this.server);
        }
    }
}

