/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.set.AbstractSetTreeController;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.ElementSetGroupTreeNode;
import cgdp.recog.set.SetCombinationTreeNode;
import cgdp.recog.set.SetCondition;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class SetCombinationTreeController
extends AbstractSetTreeController {
    private int setType;
    private ClusterTbl clusterTbl;

    public SetCombinationTreeController(Frame frame, MediatorImpl mediatorImpl, int n) {
        super(frame, mediatorImpl);
        this.setType = n;
    }

    public void createTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.clusterTbl == null) {
            return;
        }
        if (!this.clusterTbl.isExistSetCondition(this.getSetType())) {
            return;
        }
        List list = this.clusterTbl.getSetConditionList(this.getSetType());
        for (SetCondition setCondition : list) {
            if (!setCondition.isCombination()) continue;
            SetCombinationTreeNode setCombinationTreeNode = new SetCombinationTreeNode(setCondition);
            defaultMutableTreeNode.add(setCombinationTreeNode);
        }
    }

    protected List getSetConditionList(TreePath[] treePathArray) {
        ArrayList<SetCondition> arrayList = new ArrayList<SetCondition>();
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof SetCombinationTreeNode)) continue;
            SetCombinationTreeNode setCombinationTreeNode = (SetCombinationTreeNode)defaultMutableTreeNode;
            arrayList.add(setCombinationTreeNode.getSetCondition());
        }
        return arrayList;
    }

    protected List getElementSetGroupList(SetCondition setCondition, TreePath[] treePathArray) {
        ArrayList<ElementSetGroup> arrayList = new ArrayList<ElementSetGroup>();
        for (int i = 0; i < treePathArray.length; ++i) {
            ElementSetGroupTreeNode elementSetGroupTreeNode;
            ElementSetGroup elementSetGroup;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof ElementSetGroupTreeNode) || !setCondition.equalsSetCondition((elementSetGroup = (elementSetGroupTreeNode = (ElementSetGroupTreeNode)defaultMutableTreeNode).getElementSetGroup()).getSetCondition())) continue;
            arrayList.add(elementSetGroup);
        }
        return arrayList;
    }

    public void actionAfterDoubleClick(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!(defaultMutableTreeNode instanceof SetCombinationTreeNode)) {
            return;
        }
        SetCombinationTreeNode setCombinationTreeNode = (SetCombinationTreeNode)defaultMutableTreeNode;
        SetCondition setCondition = setCombinationTreeNode.getSetCondition();
        this.mediator.showSetFilterColorDialog(setCondition);
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    protected ClusterTbl getClusterTbl() {
        return this.clusterTbl;
    }

    protected int getSetType() {
        return this.setType;
    }
}

