/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.active.ColorActivation;
import cgdp.recog.active.FilterActivation;
import cgdp.recog.data.Cluster;
import cgdp.recog.project.Project;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetConditionGroupExporter;
import cgdp.recog.set.SetConditionGroupImporter;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SetConditionGroup
implements ApplicationPropertyAccessable,
FilterActivation,
ColorActivation {
    private static final ApplicationLogger logger = new ApplicationLogger(SetConditionGroup.class);
    public static final String PROPERTY_FILE_NAME = "setConditionGroup";
    private List setConditionList = new ArrayList();

    public void addSetCondition(SetCondition setCondition) {
        if (setCondition == null) {
            return;
        }
        if (this.containsSetCondition(setCondition)) {
            return;
        }
        this.setConditionList.add(setCondition);
    }

    public List getSetConditionList() {
        return this.setConditionList;
    }

    public List getSetConditionList(int n) {
        ArrayList<SetCondition> arrayList = new ArrayList<SetCondition>();
        for (SetCondition setCondition : this.setConditionList) {
            if (setCondition.getSetType() != n) continue;
            arrayList.add(setCondition);
        }
        return arrayList;
    }

    public void clearSetCondition() {
        this.setConditionList.clear();
    }

    public void removeSetCondition(SetCondition setCondition) {
        this.setConditionList.remove(setCondition);
    }

    public Set getElementSetSet(int n) {
        HashSet<AbstractElementSet> hashSet = new HashSet<AbstractElementSet>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (SetCondition setCondition : this.getSetConditionList(n)) {
            List list = setCondition.getElementSetList();
            for (AbstractElementSet abstractElementSet : list) {
                if (hashSet2.contains(abstractElementSet.getId())) continue;
                hashSet.add(abstractElementSet);
                hashSet2.add(abstractElementSet.getId());
            }
        }
        return hashSet;
    }

    public Set removeElementSet(Collection collection) {
        HashSet<SetCondition> hashSet = new HashSet<SetCondition>();
        for (SetCondition setCondition : this.getSetConditionList()) {
            setCondition.removeElementSet(collection);
            if (setCondition.isExistElementSetGroup()) continue;
            hashSet.add(setCondition);
        }
        this.setConditionList.removeAll(hashSet);
        return hashSet;
    }

    public boolean isExistSetCondition() {
        return !CollectionUtil.isNull(this.setConditionList);
    }

    public boolean isExistGeneSetCondition() {
        return this.isExistSetCondition(1);
    }

    public boolean isExistClusterSetCondition() {
        return this.isExistSetCondition(2);
    }

    public boolean isExistSetCondition(int n) {
        for (SetCondition setCondition : this.setConditionList) {
            if (setCondition.getSetType() != n) continue;
            return true;
        }
        return false;
    }

    public boolean isEnableFilter() {
        return this.isExistSetCondition() && this.isFilterActive();
    }

    public boolean isEnableColor() {
        return this.isExistSetCondition() && this.isColorActive();
    }

    public boolean isMatchFilter(Collection collection) {
        for (SetCondition setCondition : this.getSetConditionList()) {
            if (!setCondition.isMatchFilter(collection)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatchFilter(Cluster cluster) {
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        hashSet.add(cluster);
        return this.isMatchFilter(hashSet);
    }

    private boolean containsSetCondition(SetCondition setCondition) {
        if (setCondition == null) {
            return false;
        }
        return this.containsSetName(setCondition.getSetType(), setCondition.getName());
    }

    public boolean containsSetName(int n, String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        for (SetCondition setCondition : this.getSetConditionList()) {
            if (setCondition.getSetType() != n || !setCondition.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void flipFilterActive() {
        for (SetCondition setCondition : this.setConditionList) {
            setCondition.flipFilterActive();
        }
    }

    public boolean isFilterActive() {
        for (SetCondition setCondition : this.setConditionList) {
            if (!setCondition.isFilterActive()) continue;
            return true;
        }
        return false;
    }

    public void setFilterActive(boolean bl) {
        for (SetCondition setCondition : this.setConditionList) {
            setCondition.setFilterActive(bl);
        }
    }

    public void flipColorActive() {
        for (SetCondition setCondition : this.setConditionList) {
            setCondition.flipColorActive();
        }
    }

    public boolean isColorActive() {
        for (SetCondition setCondition : this.setConditionList) {
            if (!setCondition.isColorActive()) continue;
            return true;
        }
        return false;
    }

    public void setColorActive(boolean bl) {
        for (SetCondition setCondition : this.setConditionList) {
            setCondition.setColorActive(bl);
        }
    }

    public String getCategory() {
        return "ColorFilterSet";
    }

    private static String getPropertyFilepath(Project project, String string) {
        String string2 = ApplicationPropertyFacade.getPropertyDirectory(project, string) + PROPERTY_FILE_NAME;
        return string2;
    }

    public static String getPropertyFilepath(String string) {
        String string2 = new File(string, PROPERTY_FILE_NAME).getAbsolutePath();
        return string2;
    }

    public List getPropertyList(Project project, String string) {
        String string2 = SetConditionGroup.getPropertyFilepath(project, string);
        try {
            SetConditionGroupExporter setConditionGroupExporter = new SetConditionGroupExporter(string2, this);
            setConditionGroupExporter.execute();
        }
        catch (IOException iOException) {
            String string3 = "Fail to save set condition group information. " + string2;
            logger.warn(string3, iOException);
        }
        return null;
    }

    public int getPropertyType() {
        return 2;
    }

    public void updateProperty(Map map, Project project, String string) {
        String string2 = SetConditionGroup.getPropertyFilepath(project, string);
        this.updateProperty(string2);
    }

    public void updateProperty(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        if (!new File(string).isFile()) {
            return;
        }
        try {
            SetConditionGroupImporter setConditionGroupImporter = new SetConditionGroupImporter(string);
            setConditionGroupImporter.execute();
            List list = setConditionGroupImporter.getSetConditionList();
            for (SetCondition setCondition : list) {
                AbstractElementSetFacade.addSetCondition(this, setCondition);
            }
        }
        catch (IOException iOException) {
            String string2 = "Fail to load set condition group information. " + string;
            logger.warn(string2, iOException);
        }
    }

    public boolean isSyncEnable() {
        return false;
    }
}

