/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterComparator;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.data.DataManager;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClusterSet
extends AbstractElementSet {
    private String domClustId;
    private String domClustViewId;
    private String domClustFilename;

    public ClusterSet() {
        this.setSetType(2);
        this.newListFilename();
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public String getDomClustViewId() {
        return this.domClustViewId;
    }

    public void setDomClustViewId(String string) {
        this.domClustViewId = string;
    }

    public String getDomClustFilename() {
        return this.domClustFilename;
    }

    public void setDomClustFilename(String string) {
        this.domClustFilename = string;
    }

    public String getFilepath() {
        Project project = ProjectAccesser.getProject(this.getLocation());
        String string = DataManager.getClusterSetFilepath(project, this.getDomClustId(), this.getListFilename());
        return string;
    }

    public void copy(ClusterSet clusterSet) {
        if (clusterSet == null) {
            return;
        }
        this.setName(clusterSet.getName());
        this.setLocation(clusterSet.getLocation());
        this.setDomClustId(clusterSet.getDomClustId());
        this.setDomClustViewId(clusterSet.getDomClustViewId());
        this.setDomClustFilename(clusterSet.getDomClustFilename());
        this.setListFilename(clusterSet.getListFilename());
        this.setElementList(clusterSet.getElementList());
        if (!clusterSet.isExistElement()) {
            this.setElementSize(clusterSet.getElementSize());
        }
    }

    public boolean equalsClusterList(ClusterSet clusterSet) {
        if (clusterSet == null) {
            return false;
        }
        if (CollectionUtil.isNull(clusterSet.getElementList()) || CollectionUtil.isNull(this.getElementList())) {
            return false;
        }
        if (clusterSet.getElementListSize() != this.getElementListSize()) {
            return false;
        }
        Set set = ClusterUtil.getClusterIdSet(this.getElementList());
        Set set2 = ClusterUtil.getClusterIdSet(clusterSet.getElementList());
        return set.equals(set2);
    }

    public boolean equalsDomClustId(String string) {
        if (StringTool.isNull(string) || StringTool.isNull(string)) {
            return false;
        }
        return this.getDomClustId().equals(string);
    }

    public boolean isDuplicateElementSet(AbstractElementSet abstractElementSet) {
        if (abstractElementSet == null) {
            return false;
        }
        if (!(abstractElementSet instanceof ClusterSet)) {
            return false;
        }
        if (StringTool.isNull(this.getLocation()) || StringTool.isNull(abstractElementSet.getLocation())) {
            return false;
        }
        ClusterSet clusterSet = (ClusterSet)abstractElementSet;
        return clusterSet.equalsLocation(this.getLocation()) && clusterSet.equalsDomClustId(this.getDomClustId()) && clusterSet.equalsName(this.getName());
    }

    public boolean contains(Cluster cluster) {
        return this.getElementMap().containsKey(cluster.getKey());
    }

    public boolean containsAtLeast(Collection collection) {
        for (Cluster cluster : collection) {
            if (!this.contains(cluster)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Cluster cluster, String string) {
        Cluster cluster2 = (Cluster)this.getElement(cluster.getKey());
        return cluster2 != null;
    }

    public boolean contains(String string, String string2) {
        for (Cluster cluster : this.getElementList()) {
            if (!cluster.containsGeneInfo(string, string2)) continue;
            return true;
        }
        return false;
    }

    public void updateElementList() {
        List list = ClusterSetFacade.getInstance().importElementList(this);
        if (list != null) {
            this.setElementList(list);
        }
    }

    protected void updateElementMap() {
        HashMap<String, Cluster> hashMap = new HashMap<String, Cluster>();
        for (Cluster cluster : this.getElementList()) {
            String string = cluster.getKey();
            hashMap.put(string, cluster);
        }
        this.setElementMap(hashMap);
    }

    public void addElementList(Collection collection) {
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        for (Cluster cluster : collection) {
            if (this.contains(cluster)) continue;
            hashSet.add(cluster);
        }
        ArrayList arrayList = new ArrayList(this.getElementList());
        arrayList.addAll(hashSet);
        Collections.sort(arrayList, new ClusterComparator(6));
        this.setElementList(arrayList);
    }

    public AbstractElementSet intersect(AbstractElementSet abstractElementSet) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : abstractElementSet.getElementList()) {
            if (!this.contains(cluster)) continue;
            arrayList.add(cluster);
        }
        ClusterSet clusterSet = new ClusterSet();
        clusterSet.setElementList(arrayList);
        return clusterSet;
    }

    public AbstractElementSet subtract(AbstractElementSet abstractElementSet) {
        Object object2;
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Object object2 : abstractElementSet.getElementList()) {
            if (!this.contains((Cluster)object2)) continue;
            Cluster cluster = (Cluster)this.getElementMap().get(((Cluster)object2).getConbinedClusterId());
            arrayList.add(cluster);
        }
        ArrayList arrayList2 = new ArrayList(this.getElementList());
        arrayList2.removeAll(arrayList);
        object2 = new ClusterSet();
        ((AbstractElementSet)object2).setElementList(arrayList2);
        return object2;
    }
}

