/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.data.DataManager;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

class ClusterSetConfImporter
extends FileImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetConfImporter.class);
    private static final String DELIMITER = "\t";
    private List clusterSetList = new ArrayList();
    private String filepath;

    ClusterSetConfImporter() {
        this(DataManager.getClusterSetConfFilepath());
    }

    ClusterSetConfImporter(String string) {
        this.filepath = string;
    }

    protected String getFilepath() {
        return this.filepath;
    }

    protected void parseDataLine(int n, String string) {
        ClusterSet clusterSet = this.parseClusterSet(string);
        this.clusterSetList.add(clusterSet);
    }

    private ClusterSet parseClusterSet(String string) {
        Vector vector = StringTool.splitString(string, DELIMITER);
        ClusterSet clusterSet = new ClusterSet();
        clusterSet.setId(String.valueOf(vector.get(0)));
        clusterSet.setName(String.valueOf(vector.get(1)));
        clusterSet.setListFilename(String.valueOf(vector.get(2)));
        clusterSet.setLocation(String.valueOf(vector.get(3)));
        clusterSet.setDomClustId(String.valueOf(vector.get(4)));
        clusterSet.setDomClustFilename(String.valueOf(vector.get(5)));
        int n = Integer.parseInt(String.valueOf(vector.get(6)));
        clusterSet.setElementSize(n);
        return clusterSet;
    }

    protected void parseHeaderLine(String string) {
    }

    protected void beforeProcess() {
        try {
            File file = new File(this.getFilepath());
            if (!file.isFile()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            logger.warn("Fail to create cluster set conf file.", iOException);
        }
    }

    public List getClusterSetList() {
        return this.clusterSetList;
    }
}

