/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterComparator;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.set.SetFileType;
import cgdp.recog.set.gene.GeneSetImporter;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

class ClusterSetImporter
extends GeneSetImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetImporter.class);
    private ClusterTbl clusterTbl;
    private Map clusterIdMap = new HashMap();
    private List clusterList = new ArrayList();
    private boolean fromGeneList = false;

    public ClusterSetImporter(String string, ClusterTbl clusterTbl) {
        super(string);
        this.clusterTbl = clusterTbl;
        this.setRemoveDomain(false);
    }

    protected void parseDataLine(int n, String string) {
        if (SetFileType.isNoType(this.fileType)) {
            this.fileType = SetFileType.analysisFormat(string);
        }
        if (SetFileType.isNoType(this.fileType)) {
            this.geneInfoList.addAll(this.parseClusterSet(n, string));
        } else {
            super.parseDataLine(n, string);
            this.fromGeneList = true;
        }
    }

    private Vector parseClusterSet(int n, String string) {
        return StringTool.splitString(string, SetFileType.DELIMITER_DCLUST);
    }

    private void addClusterListByGeneInfo(List list) {
        for (GeneInfo geneInfo : list) {
            String string;
            String string2;
            String string3 = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
            Cluster cluster = this.clusterTbl.getCluster(string3, string2 = geneInfo.getLocusTag());
            if (cluster != null) {
                this.registerLocusTag(this.clusterIdMap, cluster, string3, string2);
                continue;
            }
            if (cluster != null || GeneUtil.isDomain(string2)) continue;
            int n = 1;
            while ((cluster = this.clusterTbl.getCluster(string3, string = GeneUtil.combineLocusTagDomainNo(string2, n))) != null) {
                this.registerLocusTag(this.clusterIdMap, cluster, string3, string);
                ++n;
            }
        }
    }

    private void addClusterListByClusterInfo(List list) {
        for (String string : list) {
            Cluster cluster = (Cluster)this.clusterIdMap.get(string);
            if (cluster != null) continue;
            cluster = new Cluster();
            cluster.setClusterId(Integer.parseInt(string));
            this.clusterIdMap.put(string, cluster);
        }
    }

    private void registerLocusTag(Map map, Cluster cluster, String string, String string2) {
        String string3 = cluster.getConbinedClusterId();
        Cluster cluster2 = (Cluster)map.get(string3);
        System.err.println("KKK" + string3 + " " + string + " " + string2 + " " + cluster2);
        if (cluster2 == null) {
            cluster2 = new Cluster();
            cluster2.setClusterId(cluster.getClusterId());
            cluster2.setSubClusterId(cluster.getSubClusterId());
            map.put(string3, cluster2);
        }
    }

    protected void afterProcess() {
        if (this.fromGeneList) {
            super.afterProcess();
            this.addClusterListByGeneInfo(this.getGeneInfoList());
        } else {
            this.addClusterListByClusterInfo(this.getGeneInfoList());
        }
        this.clusterList = new ArrayList(this.clusterIdMap.values());
        Collections.sort(this.clusterList, new ClusterComparator(6));
    }

    public List getClusterList() {
        return this.clusterList;
    }
}

