/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.color;

import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.ElementSetComparator;
import cgdp.recog.set.SetType;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.util.AbstractListSelectTableModel;
import cgdp.recog.util.ListSelectPanel;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SetSelectPanel
extends JPanel {
    private int setType;
    private SetTableModel sourceModel;
    private SetTableModel targetModel;
    private ListSelectPanel listSelectPanel;

    public SetSelectPanel(int n) {
        this.setType = n;
        this.createComponents();
    }

    private void createComponents() {
        JLabel jLabel = new JLabel("Select gene set from targets");
        this.sourceModel = new SetTableModel();
        this.targetModel = new SetTableModel();
        this.sourceModel.setDataList(this.getCandidateElementSetList());
        this.listSelectPanel = new ListSelectPanel(this.sourceModel, this.targetModel);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.listSelectPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    private List getCandidateElementSetList() {
        List list = new ArrayList();
        list = SetType.isClusterSet(this.setType) ? ClusterSetFacade.getInstance().getClusterSetListCurrentProject() : GeneSetFacade.getInstance().getGeneSetListGlobalCurrectProject();
        return list;
    }

    private class SetTableModel
    extends AbstractListSelectTableModel {
        private SetTableModel() {
        }

        public Object getValueAt(int n, int n2) {
            AbstractElementSet abstractElementSet = (AbstractElementSet)this.getDataList().get(n);
            return abstractElementSet.getName();
        }

        public int indexOf(Object object) {
            return this.getDataList().indexOf(object);
        }

        protected void removeAfter() {
            Collections.sort(this.getDataList(), new ElementSetComparator());
        }

        protected void selectAfter() {
            Collections.sort(this.getDataList(), new ElementSetComparator());
        }
    }
}

