/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.project.Project;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.system.URLList;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class GeneSetListDownloader
extends AbstractServerResourceAccesser {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSetListDownloader.class);
    private static final String DELIMITER = "\t";
    private static final String DELIMITER_SP = ",";
    private List geneSetList = new ArrayList();

    public GeneSetListDownloader(Project project) {
        this.setProject(project);
        this.setContextPath(URLList.getInstance().getGetGeneSetTitleList());
    }

    public void parseOutputStringData(int n, String string) {
        Object object;
        Vector vector = StringTool.splitString(string, DELIMITER);
        if (vector.size() != 3) {
            return;
        }
        String string2 = (String)vector.get(0);
        String string3 = (String)vector.get(1);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            object = "Fail to parse element count. " + string2;
            logger.warn((String)object, numberFormatException);
        }
        String string4 = (String)vector.get(2);
        object = new GeneSet(string2, "Server", 0);
        ((AbstractElementSet)object).setElementSize(n2);
        ((AbstractElementSet)object).setLocation(this.getProject().getProjectName());
        ((AbstractElementSet)object).newListFilename();
        GeneSet geneSet = (GeneSet)GeneSetFacade.getInstance().getSameElementSet((AbstractElementSet)object);
        if (geneSet != null) {
            ((AbstractElementSet)object).setId(geneSet.getId());
            ((AbstractElementSet)object).setListFilename(geneSet.getListFilename());
        }
        ((AbstractElementSet)object).setLocation("Server");
        this.geneSetList.add(object);
    }

    public List getGeneSetList() {
        return this.geneSetList;
    }
}

