/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractSetTreeController;
import cgdp.recog.set.SetElementAddItem;
import cgdp.recog.set.SetExportItem;
import cgdp.recog.set.SetTreeNode;
import cgdp.recog.set.cluster.ClusterSetConvertItem;
import cgdp.recog.set.color.SetFilerColorItem;
import cgdp.recog.set.gene.GeneInfoDeleteItem;
import cgdp.recog.set.gene.GeneInfoTreeNode;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetDeleteItem;
import cgdp.recog.set.gene.GeneSetDownloadItem;
import cgdp.recog.set.gene.GeneSetEditItem;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.set.gene.GeneSetRegisterItem;
import cgdp.recog.set.gene.GeneSetUploadItem;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class GeneSetTreeController
extends AbstractSetTreeController {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSetTreeController.class);

    public GeneSetTreeController(Frame frame, MediatorImpl mediatorImpl) {
        super(frame, mediatorImpl);
    }

    public void createTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        List list = GeneSetFacade.getInstance().getGeneSetListGlobalCurrectProject();
        for (GeneSet geneSet : list) {
            SetTreeNode setTreeNode = new SetTreeNode(geneSet);
            defaultMutableTreeNode.add(setTreeNode);
        }
    }

    public JPopupMenu createPopupMenu(JTree jTree, ActionListener actionListener) {
        Set set;
        Object object;
        Object object2;
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.isShowSetMenu(treePathArray)) {
            jPopupMenu.add(new GeneSetRegisterItem(actionListener, this.mediator));
            jPopupMenu.add(new GeneSetDownloadItem(actionListener, this.parent, this.mediator));
        }
        if (this.isShowSetTitleMenu(treePathArray)) {
            object2 = this.getGeneSetList(treePathArray);
            if (this.isShowFilterColorMenu(treePathArray)) {
                jPopupMenu.add(new SetFilerColorItem(actionListener, this.mediator, 1, (List)object2));
            }
            jPopupMenu.add(new ClusterSetConvertItem(actionListener, this.mediator, (Collection)object2));
            object = this.getGeneSet(treePathArray);
            set = this.getElementSetSet(treePathArray);
            jPopupMenu.addSeparator();
            jPopupMenu.add(new SetExportItem(actionListener, this.mediator, (AbstractElementSet)object));
            jPopupMenu.add(new GeneSetDownloadItem(actionListener, this.parent, this.mediator));
            jPopupMenu.add(new GeneSetUploadItem(actionListener, this.parent, this.mediator, set));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new SetElementAddItem(actionListener, this.mediator, (AbstractElementSet)object));
            jPopupMenu.add(new GeneSetEditItem(actionListener, this.parent, this.mediator, (GeneSet)object));
            jPopupMenu.add(new GeneSetDeleteItem(actionListener, this.mediator, set));
        }
        if (this.isShowElementMenu(treePathArray)) {
            object2 = this.getGeneSet(treePathArray);
            object = this.getElementSetSet(treePathArray);
            if (this.isShowDeleteElementMenu(treePathArray)) {
                set = this.getGeneInfoC(treePathArray);
                jPopupMenu.add(new GeneInfoDeleteItem(actionListener, this.parent, this.mediator, (GeneSet)object2, set));
                jPopupMenu.addSeparator();
            }
            jPopupMenu.add(new GeneSetRegisterItem(actionListener, this.mediator));
            jPopupMenu.add(new GeneSetEditItem(actionListener, this.parent, this.mediator, (GeneSet)object2));
            jPopupMenu.add(new GeneSetDeleteItem(actionListener, this.mediator, (Collection)object));
        }
        return jPopupMenu;
    }

    private GeneSet getGeneSet(TreePath[] treePathArray) {
        return (GeneSet)this.getElementSet(treePathArray);
    }

    private Set getGeneInfoC(TreePath[] treePathArray) {
        HashSet<GeneInfo> hashSet = new HashSet<GeneInfo>();
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof GeneInfoTreeNode)) continue;
            GeneInfo geneInfo = ((GeneInfoTreeNode)defaultMutableTreeNode).getGeneInfo();
            hashSet.add(geneInfo);
        }
        return hashSet;
    }

    private List getGeneSetList(TreePath[] treePathArray) {
        ArrayList<AbstractElementSet> arrayList = new ArrayList<AbstractElementSet>();
        for (int i = 0; i < treePathArray.length; ++i) {
            AbstractElementSet abstractElementSet;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof SetTreeNode) || !(abstractElementSet = ((SetTreeNode)defaultMutableTreeNode).getElementSet()).isGeneSet()) continue;
            arrayList.add(abstractElementSet);
        }
        return arrayList;
    }

    private boolean isShowSetMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 2) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isGeneSet(controlTitleNode.getControlTitleType());
    }

    private boolean isShowSetTitleMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 3) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        if (!(defaultMutableTreeNode2 instanceof SetTreeNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        SetTreeNode setTreeNode = (SetTreeNode)defaultMutableTreeNode2;
        if (!ControlTitleType.isGeneSet(controlTitleNode.getControlTitleType())) {
            return false;
        }
        return setTreeNode.getElementSet().isGeneSet();
    }

    private boolean isShowElementMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        if (!(defaultMutableTreeNode2 instanceof SetTreeNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        SetTreeNode setTreeNode = (SetTreeNode)defaultMutableTreeNode2;
        if (!ControlTitleType.isGeneSet(controlTitleNode.getControlTitleType())) {
            return false;
        }
        return setTreeNode.getElementSet().isGeneSet();
    }

    private boolean isShowFilterColorMenu(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (defaultMutableTreeNode instanceof SetTreeNode) {
                AbstractElementSet abstractElementSet = ((SetTreeNode)defaultMutableTreeNode).getElementSet();
                if (abstractElementSet instanceof GeneSet) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isShowDeleteElementMenu(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (defaultMutableTreeNode instanceof GeneInfoTreeNode) continue;
            return false;
        }
        return true;
    }

    public void actionAfterDoubleClick(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!(defaultMutableTreeNode instanceof SetTreeNode)) {
            return;
        }
        SetTreeNode setTreeNode = (SetTreeNode)defaultMutableTreeNode;
        AbstractElementSet abstractElementSet = setTreeNode.getElementSet();
        if (!abstractElementSet.isGeneSet()) {
            return;
        }
        try {
            GeneSetFacade.getInstance().editGeneSet(this.mediator, (GeneSet)abstractElementSet);
        }
        catch (Exception exception) {
            String string = "Fail to edit gene set.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this.parent, string);
        }
    }
}

