/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.venn;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.set.gene.GeneInfoOrganismLocusTagComparator;
import cgdp.recog.set.gene.GeneListTable;
import cgdp.recog.set.venn.AbstractVennInfoListDialog;
import cgdp.recog.util.ApplicationLogger;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.List;
import javax.swing.JScrollPane;

public class VennGeneInfoListDialog
extends AbstractVennInfoListDialog {
    private static final ApplicationLogger logger = new ApplicationLogger(VennGeneInfoListDialog.class);

    private VennGeneInfoListDialog(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog, mediatorImpl);
    }

    private VennGeneInfoListDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame, mediatorImpl);
    }

    public static VennGeneInfoListDialog getInstance(Component component, MediatorImpl mediatorImpl) {
        if (component instanceof Dialog) {
            return new VennGeneInfoListDialog((Dialog)component, mediatorImpl);
        }
        return new VennGeneInfoListDialog((Frame)component, mediatorImpl);
    }

    protected String getDialogTitle() {
        return "Gene List";
    }

    protected JScrollPane createInfoListTable() {
        return new GeneListTable();
    }

    protected void createSet() {
        Project project = ProjectAccesser.getSelectedProject();
        this.mediator.registerSetByGeneInfo(this, 14, project.getProjectName(), this.getGeneListTable().getGeneInfoList());
    }

    protected void export() {
        this.mediator.export(1, this.getGeneListTable().getGeneInfoList());
    }

    protected String getCountLabel() {
        return "Gene Count:";
    }

    protected String getSetButtonLabel() {
        return "Create gene set...";
    }

    protected void updateInfoListTable(List list) {
        List list2;
        try {
            list2 = GeneInfoFacade.getGeneInfoList(list, GeneListTable.getGeneInfoTitleList());
            Collections.sort(list, new GeneInfoOrganismLocusTagComparator());
        }
        catch (Exception exception) {
            logger.warn("Fail to load gene information.", exception);
            list2 = list;
        }
        this.getGeneListTable().setGeneInfoList(list2);
    }

    private GeneListTable getGeneListTable() {
        return (GeneListTable)this.elementListTable;
    }
}

