/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.taxonomy.map.RankAddScoreCalculater;
import cgdp.recog.taxonomy.map.RankGeneCountLowerCalculater;
import cgdp.recog.taxonomy.map.RankGeneCountUpperCalculater;
import cgdp.recog.taxonomy.map.RankScoreCalculater;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.GeneUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

abstract class AbstractRankScoreCalculater
implements RankScoreCalculater {
    private List taxMapInfoList = new ArrayList();
    protected TaxMapModel taxMapModel;
    private Map rankTaxMapInfoMap = new HashMap();
    private List unassignedTaxMapInfoList = new ArrayList();
    private Map rankScoreMap = new HashMap();
    private Map parentRankScoreMap = new HashMap();
    private Map childRankScoreMap = new HashMap();

    AbstractRankScoreCalculater(List list, TaxMapModel taxMapModel) {
        this.taxMapInfoList = list;
        this.taxMapModel = taxMapModel;
    }

    public static AbstractRankScoreCalculater createInstance(List list, TaxMapModel taxMapModel) {
        if (taxMapModel.isModeScoreLower()) {
            return new RankAddScoreCalculater(list, taxMapModel, taxMapModel.getGeneScoreMode());
        }
        if (taxMapModel.isModeScoreUpper()) {
            return new RankAddScoreCalculater(list, taxMapModel, taxMapModel.getGeneScoreMode());
        }
        if (taxMapModel.isModeGeneCountUpper()) {
            return new RankGeneCountUpperCalculater(list, taxMapModel);
        }
        return new RankGeneCountLowerCalculater(list, taxMapModel);
    }

    public void setRankScoreMap(Map map) {
        this.rankScoreMap = map;
    }

    public void setRankTaxMapInfoMap(Map map) {
        this.rankTaxMapInfoMap = map;
    }

    public void setUnassignedTaxMapInfoList(List list) {
        this.unassignedTaxMapInfoList = list;
    }

    public List getUnassignedTaxMapInfoList() {
        return this.unassignedTaxMapInfoList;
    }

    public Map getParentRankScoreMap() {
        return this.parentRankScoreMap;
    }

    public void setParentRankScoreMap(Map map) {
        this.parentRankScoreMap = map;
    }

    public Map getChildRankScoreMap() {
        return this.childRankScoreMap;
    }

    public void setChildRankScoreMap(Map map) {
        this.childRankScoreMap = map;
    }

    public Map getRankScoreMap() {
        return this.rankScoreMap;
    }

    public Map getRankTaxMapInfoMap() {
        return this.rankTaxMapInfoMap;
    }

    protected Map createRankScoreMap() {
        Map map = this.getRankTaxMapInfoMap();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (String string : map.keySet()) {
            List list = (List)map.get(string);
            double d = AbstractRankScoreCalculater.calcScore(this.taxMapModel, list);
            hashMap.put(string, new Double(d));
        }
        return hashMap;
    }

    static double calcScore(TaxMapModel taxMapModel, Collection collection) {
        double d = taxMapModel.isAggregateScoring() ? AbstractRankScoreCalculater.calcScoreForDomain(collection) : (double)collection.size();
        return d;
    }

    static double calcScore(TaxMapModel taxMapModel, TaxMapInfo taxMapInfo) {
        double d = taxMapModel.isAggregateScoring() ? AbstractRankScoreCalculater.calcScoreForDomain(taxMapInfo) : 1.0;
        return d;
    }

    private static double calcScoreForDomain(Collection collection) {
        double d = 0.0;
        for (TaxMapInfo taxMapInfo : collection) {
            d += AbstractRankScoreCalculater.calcScoreForDomain(taxMapInfo);
        }
        return d;
    }

    private static double calcScoreForDomain(TaxMapInfo taxMapInfo) {
        double d;
        String string = taxMapInfo.getOrganismCode();
        String string2 = GeneUtil.removeDomainNo(taxMapInfo.getLocusTag());
        try {
            GeneInfoTitle geneInfoTitle = GeneInfoFacade.getGeneInfoTitle("num_domain");
            int n = ((Number)GeneInfoFacade.getValue(string, string2, geneInfoTitle)).intValue();
            d = 1.0 / (double)n;
        }
        catch (Exception exception) {
            d = 1.0;
        }
        return d;
    }

    protected List getTaxMapInfoListByAggregateType() {
        if (this.taxMapModel.isAggregateMaxScoreInfo()) {
            return this.aggregateTaxMapInfoByLocusTag(this.taxMapInfoList);
        }
        return this.taxMapInfoList;
    }

    private List aggregateTaxMapInfoByLocusTag(List list) {
        HashSet<Object> hashSet;
        Object object;
        HashMap<String, HashSet<Object>> hashMap = new HashMap<String, HashSet<Object>>();
        for (Object object2 : list) {
            Object object3 = ((TaxMapInfo)object2).getLocusTag();
            object = GeneUtil.removeDomainNo((String)object3);
            hashSet = (HashSet<Object>)hashMap.get(object);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                hashMap.put((String)object, hashSet);
            }
            hashSet.add(object2);
        }
        ArrayList arrayList = new ArrayList(this.taxMapInfoList);
        for (Object object3 : hashMap.values()) {
            if (object3.size() == 1) continue;
            object = this.getMaxScoreTaxMapInfo((Collection)object3);
            hashSet = new HashSet(object3);
            hashSet.remove(object);
            arrayList.removeAll(hashSet);
        }
        return arrayList;
    }

    private TaxMapInfo getMaxScoreTaxMapInfo(Collection collection) {
        TaxMapInfo taxMapInfo = null;
        for (TaxMapInfo taxMapInfo2 : collection) {
            double d;
            if (taxMapInfo == null) {
                taxMapInfo = taxMapInfo2;
                continue;
            }
            double d2 = this.getScore(taxMapInfo2);
            if (!(d2 > (d = this.getScore(taxMapInfo)))) continue;
            taxMapInfo = taxMapInfo2;
        }
        return taxMapInfo;
    }

    private double getScore(TaxMapInfo taxMapInfo) {
        if (this.taxMapModel.isLower()) {
            return taxMapInfo.getLowerScore();
        }
        return taxMapInfo.getUpperScore();
    }
}

