/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.option.OptionTbl;
import cgdp.recog.taxonomy.map.TaxMapImporter;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.util.SimpleServerConnection;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class TaxMapDownloader
extends SimpleServerConnection {
    private String domClustId;
    private Set mappingOrganismCodeSet = new HashSet();
    private StringBuffer sb = new StringBuffer();
    private List taxMapInfoList = new ArrayList();

    public TaxMapDownloader(String string, Set set) {
        this.domClustId = string;
        this.mappingOrganismCodeSet = set;
        this.setContextPath(OptionTbl.getInstance().getOptionValues().getTaxMapDownloadURL());
        this.setOptions();
    }

    public void parseOutputString(int n, String string) {
        if (!string.startsWith("#Cluster")) {
            Vector vector = StringTool.splitString(string, "\t");
            if (vector.size() != 4) {
                return;
            }
            String string2 = ((String)vector.get(2)).trim();
            String string3 = ((String)vector.get(3)).trim();
            if (StringTool.isNull(string2) && StringTool.isNull(string3)) {
                return;
            }
            TaxMapInfo taxMapInfo = TaxMapImporter.createTaxMapInfo(string);
            this.taxMapInfoList.add(taxMapInfo);
        }
    }

    private void setOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("tabid=");
        stringBuffer.append(this.domClustId);
        stringBuffer.append("&mapspec=");
        stringBuffer.append(StringTool.conbineStrList(this.mappingOrganismCodeSet, ","));
        stringBuffer.append("&mode=text");
        this.setOptions(stringBuffer.toString());
    }

    public List getTaxMapInfoList() {
        return this.taxMapInfoList;
    }
}

