/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.organism.OrganismSelectPanel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TaxMapExecuteDialog
extends AbstractApplyDialog {
    private static TaxMapExecuteDialog TAXMAP_EXECUTE_DIALOG;
    private static final String TITLE = "Execute taxonomy mapping";
    private MediatorImpl mediator;
    private OrganismSelectPanel organismSelectPanel;

    private TaxMapExecuteDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        TAXMAP_EXECUTE_DIALOG = new TaxMapExecuteDialog(frame, mediatorImpl);
    }

    public static TaxMapExecuteDialog getInstance() {
        return TAXMAP_EXECUTE_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setResizable(true);
        this.setModal(true);
        this.organismSelectPanel = new OrganismSelectPanel(false, false);
        this.setApplyButtonName("Run");
        this.setCloseButtonName("Close");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.organismSelectPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 10, 10, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(List list, List list2) {
        this.organismSelectPanel.updateValue(list, list2);
    }

    public Set getSelectedOrganismCodeSet() {
        return new HashSet(this.organismSelectPanel.getTargetOrganismCodeList());
    }

    protected boolean check() {
        if (CollectionUtil.isNull(this.getSelectedOrganismCodeSet())) {
            String string = "Select organism.";
            MessageManager.showErrorMessage((Component)this, string);
            return false;
        }
        return true;
    }

    protected boolean apply() {
        return true;
    }
}

