/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.taxonomy.map.TaxMapGraphNumDataCreater;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.AbstractFileExporter;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;

class TaxMapGraphNumDataExporter
extends AbstractFileExporter {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapGraphNumDataExporter.class);
    private static final String DELIMITER = "\t";
    private static final String HEADER = "Name\tMean\tMedian\tMin\tMax\tQ1\tQ3";
    private TaxMapModel taxMapModel;
    private AbstractInfoTitle infoTitle;

    TaxMapGraphNumDataExporter(TaxMapModel taxMapModel, AbstractInfoTitle abstractInfoTitle) {
        this.taxMapModel = taxMapModel;
        this.infoTitle = abstractInfoTitle;
    }

    protected String getContents() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = !this.taxMapModel.isExistSelectedNode();
            TaxMapGraphNumDataCreater taxMapGraphNumDataCreater = new TaxMapGraphNumDataCreater(this.taxMapModel, this.infoTitle, bl);
            DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = taxMapGraphNumDataCreater.createDataset();
            stringBuffer.append(HEADER);
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            for (int i = 0; i < defaultBoxAndWhiskerCategoryDataset.getColumnCount(); ++i) {
                Comparable comparable = defaultBoxAndWhiskerCategoryDataset.getColumnKey(i);
                stringBuffer.append(comparable);
                stringBuffer.append(DELIMITER);
                stringBuffer.append(defaultBoxAndWhiskerCategoryDataset.getMeanValue(0, i));
                stringBuffer.append(DELIMITER);
                stringBuffer.append(defaultBoxAndWhiskerCategoryDataset.getMedianValue(0, i));
                stringBuffer.append(DELIMITER);
                stringBuffer.append(defaultBoxAndWhiskerCategoryDataset.getMinRegularValue(0, i));
                stringBuffer.append(DELIMITER);
                stringBuffer.append(defaultBoxAndWhiskerCategoryDataset.getMaxRegularValue(0, i));
                stringBuffer.append(DELIMITER);
                stringBuffer.append(defaultBoxAndWhiskerCategoryDataset.getQ1Value(0, i));
                stringBuffer.append(DELIMITER);
                stringBuffer.append(defaultBoxAndWhiskerCategoryDataset.getQ3Value(0, i));
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            String string = "Fail to export property graph data.";
            logger.warn(string, exception);
            return "";
        }
    }
}

