/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.organism.OrganismSelectPanel;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TaxMapScoreCalcDialog
extends AbstractApplyDialog {
    private static TaxMapScoreCalcDialog TAXMAP_SCORE_CALC_DIALOG;
    private static final String TITLE = "Taxnomy Mapping Score Calculation";
    private MediatorImpl mediator;
    private int inoutType;
    private JCheckBox saveCheckBox;
    private FocusTextField nameTextField;
    private OrganismSelectPanel organismSelectPanel;

    public TaxMapScoreCalcDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        TAXMAP_SCORE_CALC_DIALOG = new TaxMapScoreCalcDialog(frame, mediatorImpl);
    }

    public static TaxMapScoreCalcDialog getInstance() {
        return TAXMAP_SCORE_CALC_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setResizable(true);
        this.setModal(true);
        this.organismSelectPanel = new OrganismSelectPanel(false, false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createNamePane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.organismSelectPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 10, 10, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createNamePane() {
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        this.saveCheckBox = new JCheckBox("Save");
        this.saveCheckBox.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.saveCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    public void updateValue(List list, List list2, int n) {
        this.inoutType = n;
        this.organismSelectPanel.updateValue(list, list2);
        this.setEnableName();
    }

    private void setEnableName() {
        this.nameTextField.setEnabled(this.saveCheckBox.isSelected());
    }

    private String getScoreName() {
        return this.nameTextField.getText();
    }

    private boolean isSave() {
        return this.saveCheckBox.isSelected();
    }

    public Set getSelectedOrganismCodeSet() {
        return new HashSet(this.organismSelectPanel.getTargetOrganismCodeList());
    }

    public CellInfoTitle createCellInfoTitle() {
        CellInfoTitle cellInfoTitle;
        if (this.isSave()) {
            Project project = ProjectAccesser.getSelectedProject();
            cellInfoTitle = CellInfoTitle.createInfoTitle(this.getScoreName(), this.getScoreName(), 1, project.getProjectName());
            cellInfoTitle.setCategory(4);
        } else {
            cellInfoTitle = CellInfoFacade.getCellInfoTitle("tax_map_score", this.inoutType);
        }
        return cellInfoTitle;
    }

    protected boolean check() {
        Object object;
        if (this.isSave()) {
            if (StringTool.isNull(this.getScoreName())) {
                String string = "Input name.";
                MessageManager.showErrorMessage((Component)this, string);
                return false;
            }
            object = this.createCellInfoTitle();
            List list = CellInfoFacade.getInfoTitleList();
            if (list.contains(object)) {
                Object[] objectArray = new String[]{"You have already calculated the  [" + this.getScoreName() + "].", "Input the another name."};
                MessageManager.showConfirmMessage((Component)this, objectArray);
                return false;
            }
        }
        if (CollectionUtil.isNull(this.getSelectedOrganismCodeSet())) {
            object = "Select organism.";
            MessageManager.showErrorMessage((Component)this, (String)object);
            return false;
        }
        return true;
    }

    protected boolean apply() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.saveCheckBox) {
            this.setEnableName();
        }
    }
}

