/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.taxonomy.map.CategoryDatasetTableModel;
import cgdp.recog.taxonomy.map.DefaultBoxAndWhiskerCategoryDatasetTableModel;
import cgdp.recog.taxonomy.map.PieDatasetTableModel;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.AbstractApplyDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;

class TaxMapTableDialog
extends AbstractApplyDialog {
    private static final int PIE_DATA = 1;
    private static final int CATEGORY_DATA = 2;
    private static final int NUMERIC_DATA = 3;
    private ClusterTbl clusterTbl;
    private int dataType;
    private TaxMapModel taxMapModel;
    private JTable table;
    private JButton exportButton;

    public TaxMapTableDialog(Frame frame, ClusterTbl clusterTbl) {
        super(frame);
        this.clusterTbl = clusterTbl;
        this.createComponents();
    }

    private void createComponents() {
        this.setResizable(true);
        this.setModal(true);
        this.table = new JTable();
        this.table.setAutoResizeMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.table, 20, 30);
        this.exportButton = new JButton("Export...");
        this.exportButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.exportButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 10, 15), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(ClusterTbl clusterTbl, TaxMapModel taxMapModel, Dataset dataset, String string) {
        this.taxMapModel = taxMapModel;
        this.setDataType(dataset);
        this.setTitle(string);
        this.table.setModel(this.createTableModel(dataset));
        this.pack();
    }

    private void setDataType(Dataset dataset) {
        this.dataType = dataset instanceof DefaultBoxAndWhiskerCategoryDataset ? 3 : (dataset instanceof PieDataset ? 1 : 2);
    }

    private int getDataType() {
        return this.dataType;
    }

    private boolean isPieData() {
        return this.getDataType() == 1;
    }

    private boolean isCategoryData() {
        return this.getDataType() == 2;
    }

    private boolean isNumericData() {
        return this.getDataType() == 3;
    }

    private AbstractTableModel createTableModel(Dataset dataset) {
        if (this.isNumericData()) {
            DefaultBoxAndWhiskerCategoryDatasetTableModel defaultBoxAndWhiskerCategoryDatasetTableModel = new DefaultBoxAndWhiskerCategoryDatasetTableModel();
            defaultBoxAndWhiskerCategoryDatasetTableModel.setDataset((DefaultBoxAndWhiskerCategoryDataset)dataset);
            return defaultBoxAndWhiskerCategoryDatasetTableModel;
        }
        if (this.isPieData()) {
            PieDatasetTableModel pieDatasetTableModel = new PieDatasetTableModel();
            pieDatasetTableModel.setPieDataset((PieDataset)dataset);
            return pieDatasetTableModel;
        }
        CategoryDatasetTableModel categoryDatasetTableModel = new CategoryDatasetTableModel();
        categoryDatasetTableModel.setDataset((CategoryDataset)dataset);
        return categoryDatasetTableModel;
    }

    private void export() {
        if (this.isPieData()) {
            TaxMapFacade.exportPopulationData(this, this.taxMapModel);
        } else {
            TaxMapFacade.exportGraphData(this, this.taxMapModel, this.clusterTbl, this.taxMapModel.getSelectedInfoTitle());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.exportButton) {
            this.export();
        }
    }

    protected boolean apply() {
        return true;
    }
}

