/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.update;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.update.VersionUpTask;
import cgdp.recog.util.AbstractApplyDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;

public class DataVersionUpTask
implements VersionUpTask {
    private MediatorImpl mediator;
    private Frame parent;
    private String version;

    public DataVersionUpTask(Frame frame, MediatorImpl mediatorImpl, String string) {
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.version = string;
    }

    public boolean equalsTask(VersionUpTask versionUpTask) {
        return versionUpTask instanceof DataVersionUpTask;
    }

    public void run() {
        DataVersionUpInfoDialog dataVersionUpInfoDialog = new DataVersionUpInfoDialog(this.parent, this.version);
        dataVersionUpInfoDialog.setVisible(true);
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        optionValues.setShowVersionUp(dataVersionUpInfoDialog.isShowVersionUp());
        if (!dataVersionUpInfoDialog.isCanceled()) {
            this.mediator.updateDatas(1);
        }
        dataVersionUpInfoDialog.dispose();
    }

    private class DataVersionUpInfoDialog
    extends AbstractApplyDialog {
        private final String TITLE = "Information";
        private String dataVersion;
        private JCheckBox continueCheckUpdateCheckBox;

        public DataVersionUpInfoDialog(Frame frame, String string) {
            super(frame);
            this.TITLE = "Information";
            this.dataVersion = string;
            this.createComponents();
        }

        private void createComponents() {
            this.setTitle("Information");
            this.setModal(true);
            String string = "New gene data (" + this.dataVersion + ") is released!";
            JEditorPane jEditorPane = new JEditorPane("text/html", string);
            jEditorPane.setEditable(false);
            jEditorPane.setOpaque(false);
            this.setApplyButtonName("Update taxonomy only");
            OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
            this.continueCheckUpdateCheckBox = new JCheckBox("In the future, this message should not be displayed");
            this.continueCheckUpdateCheckBox.setSelected(!optionValues.isShowVersionUp());
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)jEditorPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
            this.getContentPane().add((Component)this.continueCheckUpdateCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 20, 10, 10), 0, 0));
            this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(15, 10, 15, 10), 0, 0));
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        public boolean isShowVersionUp() {
            return !this.continueCheckUpdateCheckBox.isSelected();
        }

        protected boolean apply() {
            return true;
        }
    }
}

