/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.url;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.url.GeneUrl;
import cgdp.recog.url.KeyTableModel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class GeneUrlEditDialog
extends AbstractApplyDialog {
    private static GeneUrlEditDialog GENE_URL_EDIT_DIALOG;
    private static final String TITLE = "Edit URL";
    private FocusTextField nameTextField;
    private FocusTextField urlTextField;
    private JTable keyTable;
    private JButton addButton;
    private JButton deleteButton;
    private KeyListDialog keyListDialog;
    private GeneUrl targetGeneUrl;
    private List geneUrlList;

    private GeneUrlEditDialog(Dialog dialog) {
        super(dialog);
        this.createComponents();
        this.keyListDialog = new KeyListDialog(this);
    }

    public static void createInstance(Dialog dialog) {
        if (GENE_URL_EDIT_DIALOG != null) {
            return;
        }
        GENE_URL_EDIT_DIALOG = new GeneUrlEditDialog(dialog);
    }

    public static GeneUrlEditDialog getInstance() {
        return GENE_URL_EDIT_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        JLabel jLabel2 = new JLabel("URL");
        this.urlTextField = new FocusTextField();
        JLabel jLabel3 = new JLabel("Key");
        JPanel jPanel = this.createKeyPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.urlTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createKeyPanel() {
        this.keyTable = new JTable(new KeyTableModel());
        this.keyTable.setRowHeight(20);
        this.keyTable.setTableHeader(null);
        JScrollPane jScrollPane = new JScrollPane(this.keyTable, 20, 31);
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 10), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 10), 0, 0));
        return jPanel2;
    }

    void updateValue(GeneUrl geneUrl, List list) {
        Object object;
        this.targetGeneUrl = geneUrl;
        this.geneUrlList = list;
        if (geneUrl == null) {
            this.nameTextField.setText("");
            this.urlTextField.setText("");
            object = this.getKeyTableModel();
            ((KeyTableModel)object).setKeyList(new ArrayList());
        } else {
            this.nameTextField.setText(geneUrl.getName());
            this.urlTextField.setText(geneUrl.getUrlTemplate());
            object = this.getKeyTableModel();
            ((KeyTableModel)object).setKeyList(geneUrl.getKeyList());
        }
        object = GeneInfoFacade.getGeneInfoTitleList();
        object.addAll(ClusterInfoFacade.createSelectableClusterInfoTitleList());
        this.keyListDialog.updateValue((List)object);
    }

    protected boolean check() {
        if (StringTool.isNull(this.getName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        if (StringTool.isNull(this.getUrlTemplate())) {
            MessageManager.showErrorMessage((Component)this, "Input URL.");
            return false;
        }
        GeneUrl geneUrl = this.getGeneUrl();
        if (!geneUrl.validatePlaceHolder()) {
            MessageManager.showErrorMessage((Component)this, "Key is not correct.");
            return false;
        }
        for (GeneUrl geneUrl2 : this.geneUrlList) {
            if (!geneUrl2.getName().equals(this.getName()) || this.targetGeneUrl != null && (this.targetGeneUrl == null || this.targetGeneUrl.getName().equals(this.getName()))) continue;
            MessageManager.showErrorMessage((Component)this, "Duplication name. [" + this.getName() + "]");
            return false;
        }
        return true;
    }

    protected boolean apply() {
        return true;
    }

    public String getName() {
        return this.nameTextField.getText();
    }

    public String getUrlTemplate() {
        return this.urlTextField.getText();
    }

    public List getKeyList() {
        return this.getKeyTableModel().getKeyList();
    }

    public GeneUrl getGeneUrl() {
        GeneUrl geneUrl = new GeneUrl();
        geneUrl.setName(this.getName());
        geneUrl.setUrlTemplate(this.getUrlTemplate());
        geneUrl.setKeyList(this.getKeyList());
        if (this.targetGeneUrl != null) {
            geneUrl.setDef(this.targetGeneUrl.isDef());
        }
        return geneUrl;
    }

    private KeyTableModel getKeyTableModel() {
        return (KeyTableModel)this.keyTable.getModel();
    }

    private void add() {
        this.keyListDialog.setVisible(true);
        if (this.keyListDialog.isCanceled()) {
            return;
        }
        AbstractInfoTitle abstractInfoTitle = this.keyListDialog.getKey();
        KeyTableModel keyTableModel = this.getKeyTableModel();
        keyTableModel.add(abstractInfoTitle);
    }

    private void delete() {
        int[] nArray = this.keyTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        KeyTableModel keyTableModel = this.getKeyTableModel();
        for (int i = nArray.length - 1; i >= 0; --i) {
            keyTableModel.remove(nArray[i]);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.addButton) {
            this.add();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        }
    }

    private class KeyListDialog
    extends AbstractApplyDialog {
        private JComboBox keyComboBox;
        private List keyList;

        public KeyListDialog(Dialog dialog) {
            super(dialog);
            this.createComponents();
        }

        private void createComponents() {
            this.setTitle(GeneUrlEditDialog.TITLE);
            this.setModal(true);
            this.setResizable(false);
            JLabel jLabel = new JLabel("Key");
            this.keyComboBox = new JComboBox();
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.getContentPane().add((Component)this.keyComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 10, 10), 0, 0));
            this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        public void updateValue(List list) {
            this.keyList = list;
            String string = (String)this.keyComboBox.getSelectedItem();
            this.keyComboBox.removeAllItems();
            int n = 0;
            int n2 = 0;
            for (AbstractInfoTitle abstractInfoTitle : list) {
                this.keyComboBox.addItem(abstractInfoTitle.getName());
                if (abstractInfoTitle.getName().equals(string)) {
                    n = n2;
                }
                ++n2;
            }
            this.keyComboBox.setSelectedIndex(n);
        }

        protected boolean apply() {
            return true;
        }

        public AbstractInfoTitle getKey() {
            int n = this.keyComboBox.getSelectedIndex();
            return (AbstractInfoTitle)this.keyList.get(n);
        }
    }
}

