/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.process.CommandImpl;
import cgdp.recog.util.TreeUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTree
extends JTree
implements ActionListener,
MouseListener {
    private boolean windowsFlag = false;

    public AbstractTree(boolean bl) {
        this.windowsFlag = bl;
    }

    protected abstract MutableTreeNode createTreeStructure();

    protected abstract void setVisibleRoot();

    public void updateTree() {
        TreePath[] treePathArray = this.getSelectionPaths();
        List list = TreeUtil.saveExpandedState(this);
        MutableTreeNode mutableTreeNode = this.createTreeStructure();
        ((DefaultTreeModel)this.getModel()).setRoot(mutableTreeNode);
        this.setVisibleRoot();
        if (!list.isEmpty()) {
            TreeUtil.expandAll(this, list, true);
        }
        if (treePathArray != null && treePathArray.length != 0) {
            for (int i = 0; i < treePathArray.length; ++i) {
                TreePath treePath = this.getPathForRow(this.getRowForPath(treePathArray[i]));
                this.addSelectionPath(treePath);
            }
        }
    }

    public void reload() {
        TreePath[] treePathArray = this.getSelectionPaths();
        List list = TreeUtil.saveExpandedState(this);
        ((DefaultTreeModel)this.getModel()).reload();
        this.treeDidChange();
        if (!list.isEmpty()) {
            TreeUtil.expandAll(this, list, true);
        }
        if (treePathArray != null && treePathArray.length != 0) {
            for (int i = 0; i < treePathArray.length; ++i) {
                TreePath treePath = this.getPathForRow(this.getRowForPath(treePathArray[i]));
                this.addSelectionPath(treePath);
            }
        }
    }

    private void expandAll() {
        Object object = this.getModel().getRoot();
        if (object instanceof DefaultMutableTreeNode) {
            this.expandAll((DefaultMutableTreeNode)object);
        }
    }

    private void expandAll(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            this.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
            if (defaultMutableTreeNode2.isLeaf()) continue;
            this.expandAll(defaultMutableTreeNode2);
        }
    }

    public void expandByOneStep() {
        Object object = this.getModel().getRoot();
        if (object instanceof DefaultMutableTreeNode) {
            this.expandAll((DefaultMutableTreeNode)object);
            int n = this.getMinLayerCountOfCollapseNode((DefaultMutableTreeNode)object, 0);
            this.expandByOneStep((DefaultMutableTreeNode)object, 0, n);
        }
    }

    private int getMinLayerCountOfCollapseNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (!this.isExpanded(new TreePath(defaultMutableTreeNode.getPath()))) {
            return n;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n3; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) continue;
            n2 = Math.min(this.getMinLayerCountOfCollapseNode(defaultMutableTreeNode2, n + 1), n2);
        }
        return n2;
    }

    private void expandByOneStep(DefaultMutableTreeNode defaultMutableTreeNode, int n, int n2) {
        if (n > n2) {
            return;
        }
        this.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        int n3 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n3; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            this.expandByOneStep(defaultMutableTreeNode2, n + 1, n2);
        }
    }

    public void collapseByOneStep() {
        Object object = this.getModel().getRoot();
        if (object instanceof DefaultMutableTreeNode) {
            int n = this.getMaxLayerCountOfExpandNode((DefaultMutableTreeNode)object, 0);
            this.collapseByOneStep((DefaultMutableTreeNode)object, 0, n - 1);
        }
    }

    private int getMaxLayerCountOfExpandNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (this.isCollapsed(new TreePath(defaultMutableTreeNode.getPath()))) {
            return n;
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n3; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            n2 = Math.max(this.getMaxLayerCountOfExpandNode(defaultMutableTreeNode2, n + 1), n2);
        }
        return n2;
    }

    private void collapseByOneStep(DefaultMutableTreeNode defaultMutableTreeNode, int n, int n2) {
        if (n >= n2) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            if (!this.isCollapsed(treePath)) {
                this.collapsePath(treePath);
            }
            return;
        }
        int n3 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n3; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) continue;
            this.collapseByOneStep(defaultMutableTreeNode2, n + 1, n2);
        }
    }

    protected List getTreeNodeList(TreePath[] treePathArray) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            arrayList.add(defaultMutableTreeNode);
        }
        return arrayList;
    }

    protected abstract void showPopup(Point var1);

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof CommandImpl) {
            ((CommandImpl)actionEvent.getSource()).execute();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.windowsFlag) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            this.showPopup(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.windowsFlag) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            this.showPopup(mouseEvent.getPoint());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

