/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class ColorUtil {
    private ColorUtil() {
    }

    public static boolean isColor(String string) {
        if (string.length() != 7) {
            return false;
        }
        if (!string.startsWith("#")) {
            return false;
        }
        try {
            Integer.parseInt(string.substring(1), 16);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Color str2Color(String string) {
        int n = Integer.parseInt(string.substring(1), 16);
        return new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static List str2ColorList(List list) {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        for (String string : list) {
            Color color = ColorUtil.str2Color(string);
            arrayList.add(color);
        }
        return arrayList;
    }

    public static String color2Str(Color color) {
        String string = Integer.toString(color.getRed(), 16);
        string = string.length() == 1 ? "0" + string : string;
        String string2 = Integer.toString(color.getGreen(), 16);
        string2 = string2.length() == 1 ? "0" + string2 : string2;
        String string3 = Integer.toString(color.getBlue(), 16);
        string3 = string3.length() == 1 ? "0" + string3 : string3;
        return "#" + string + string2 + string3;
    }

    public static List color2StrList(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        for (Color color : list) {
            String string = ColorUtil.color2Str(color);
            arrayList.add(string);
        }
        return arrayList;
    }
}

