/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ListTable
extends JScrollPane {
    private JTable table;
    private boolean selectLock;
    private Map columnWidthMap = new HashMap();
    private Map cellRendererMap = new HashMap();
    private Map cellEditorMap = new HashMap();

    public ListTable(TableModel tableModel) {
        this.init(tableModel);
    }

    private void init(TableModel tableModel) {
        this.table = new JTable(tableModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                return ListTable.this.getTableToolTipText(mouseEvent);
            }
        };
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.getTableHeader().setPreferredSize(new Dimension(0, 0));
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListTable.this.actionListSelectionListener(listSelectionEvent);
            }
        };
        listSelectionModel.addListSelectionListener(listSelectionListener);
        this.getViewport().setBackground(Color.white);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.setViewportView(this.table);
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public int getSelectedRowCount() {
        return this.table.getSelectedRowCount();
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    public void addRowSelectionInterval(int n, int n2) {
        this.table.addRowSelectionInterval(n, n2);
    }

    public void setRowSelectionInterval(int n, int n2) {
        this.table.setRowSelectionInterval(n, n2);
    }

    public void setColumnWidth(int n, int n2) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        this.columnWidthMap.put(new Integer(n), new Integer(n2));
    }

    private void setColumnWidth() {
        for (Integer n : this.columnWidthMap.keySet()) {
            int n2 = n;
            int n3 = (Integer)this.columnWidthMap.get(n);
            this.setColumnWidth(n2, n3);
        }
    }

    public void setRenderer(int n, TableCellRenderer tableCellRenderer) {
        this.table.getColumnModel().getColumn(n).setCellRenderer(tableCellRenderer);
        this.cellRendererMap.put(new Integer(n), tableCellRenderer);
    }

    private void setRenderer() {
        for (Integer n : this.cellRendererMap.keySet()) {
            int n2 = n;
            TableCellRenderer tableCellRenderer = (TableCellRenderer)this.cellRendererMap.get(n);
            this.table.getColumnModel().getColumn(n2).setCellRenderer(tableCellRenderer);
        }
    }

    public void setEditor(int n, TableCellEditor tableCellEditor) {
        this.table.getColumnModel().getColumn(n).setCellEditor(tableCellEditor);
        this.cellEditorMap.put(new Integer(n), tableCellEditor);
    }

    private void setEditor() {
        for (Integer n : this.cellEditorMap.keySet()) {
            int n2 = n;
            TableCellEditor tableCellEditor = (TableCellEditor)this.cellEditorMap.get(n);
            this.table.getColumnModel().getColumn(n2).setCellEditor(tableCellEditor);
        }
    }

    public void updateView() {
        this.setColumnWidth();
        this.setRenderer();
        this.setEditor();
    }

    public TableModel getModel() {
        return this.table.getModel();
    }

    public void setViewPortPreferredSize(Dimension dimension) {
        this.getViewport().setPreferredSize(dimension);
    }

    public void setLabelFor(JLabel jLabel) {
        jLabel.setLabelFor(this.table);
    }

    public final boolean isSelectLock() {
        return this.selectLock;
    }

    public final void lockSelect() {
        this.selectLock = true;
    }

    public final void unlockSelect() {
        this.selectLock = false;
    }

    protected String getTableToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    public void setEnableComponents(boolean bl) {
        this.table.setEnabled(bl);
    }

    protected void actionListSelectionListener(ListSelectionEvent listSelectionEvent) {
    }
}

