/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.server.AccessServer;
import cgdp.recog.server.ServerAccessException;
import cgdp.recog.util.AbstractServerConnection;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ResourceBandleWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.URLConnection;

public abstract class SimpleServerConnection
extends AbstractServerConnection {
    private static final ApplicationLogger logger = new ApplicationLogger(SimpleServerConnection.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        if (this.isDebug()) {
            return;
        }
        if (!AccessServer.getInstance().isEnableAccess()) {
            throw new ServerAccessException();
        }
        this.before();
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            URLConnection uRLConnection = this.postServer();
            if (!SimpleServerConnection.checkHttpStatus(uRLConnection)) {
                this.setError();
                this.setMessage(ResourceBandleWrapper.getMessage("error.access.server"));
                return;
            }
            inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            this.loadServerOutput(bufferedReader);
        }
        catch (ConnectException connectException) {
            this.setError();
            this.setMessage(ResourceBandleWrapper.getMessage("error.access.server"));
            logger.warn(ResourceBandleWrapper.getMessage("error.access.server"), connectException);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            this.after();
        }
    }

    protected void loadServerOutput(BufferedReader bufferedReader) throws IOException {
        String string;
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (!this.setParameter(string) && !this.isError()) {
                if (this.isCanceled()) break;
                this.parseOutputString(n, string);
            }
            ++n;
        }
    }
}

