/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util.treetable;

import cgdp.recog.util.treetable.TreeTableModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractTreeTableModel() {
        this(null);
    }

    public AbstractTreeTableModel(Object object) {
        this.root = object;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode treeNode) {
        Object object = this.root;
        this.root = treeNode;
        if (treeNode == null && object != null) {
            this.fireTreeStructureChanged(this, null);
        } else {
            this.nodeStructureChanged(treeNode);
        }
    }

    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        for (int i = 0; i < this.getChildCount(object); ++i) {
            if (!this.getChild(object, i).equals(object2)) continue;
            return i;
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    private void fireTreeStructureChanged(Object object, Object[] objectArray) {
        Object[] objectArray2 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
            if (objectArray2[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray);
            }
            ((TreeModelListener)objectArray2[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesChanged(TreeNode treeNode) {
        if (treeNode != null) {
            this.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), null, null);
        }
    }

    protected void nodeStructureChanged(TreeNode treeNode) {
        if (treeNode != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(treeNode), null, null);
        }
    }

    public TreeNode[] getPathToRoot(TreeNode treeNode) {
        return this.getPathToRoot(treeNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
        TreeNode[] treeNodeArray;
        if (treeNode == null) {
            if (n == 0) {
                return null;
            }
            treeNodeArray = new TreeNode[n];
        } else {
            treeNodeArray = treeNode == this.root ? new TreeNode[n] : this.getPathToRoot(treeNode.getParent(), ++n);
            treeNodeArray[treeNodeArray.length - n] = treeNode;
        }
        return treeNodeArray;
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    public boolean isCellEditable(Object object, int n) {
        return this.getColumnClass(n) == TreeTableModel.class;
    }

    public void setValueAt(Object object, Object object2, int n) {
    }
}

