/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.wizard;

import cgdp.recog.wizard.WizardController;
import cgdp.recog.wizard.WizardModel;
import cgdp.recog.wizard.WizardPanelDescriptor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class Wizard
extends WindowAdapter
implements PropertyChangeListener {
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final String NEXT_BUTTON_ACTION_COMMAND = "NextButtonActionCommand";
    public static final String BACK_BUTTON_ACTION_COMMAND = "BackButtonActionCommand";
    public static final String CANCEL_BUTTON_ACTION_COMMAND = "CancelButtonActionCommand";
    public static final String FINISH_BUTTON_ACTION_COMMAND = "FinishButtonActionCommand";
    static String BACK_TEXT = "Back";
    static String NEXT_TEXT = "Next";
    static String FINISH_TEXT = "Apply";
    static String CANCEL_TEXT = "Cancel";
    private WizardModel wizardModel = new WizardModel();
    private WizardController wizardController;
    private JDialog wizardDialog;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private JButton finishButton;
    private int returnCode;

    public Wizard() {
        this((Frame)null);
    }

    public Wizard(Dialog dialog) {
        this.wizardDialog = new JDialog(dialog);
        this.initComponents();
    }

    public Wizard(Frame frame) {
        this.wizardDialog = new JDialog(frame);
        this.initComponents();
    }

    public JDialog getDialog() {
        return this.wizardDialog;
    }

    public Component getOwner() {
        return this.wizardDialog.getOwner();
    }

    public void setTitle(String string) {
        this.wizardDialog.setTitle(string);
    }

    public String getTitle() {
        return this.wizardDialog.getTitle();
    }

    public void setModal(boolean bl) {
        this.wizardDialog.setModal(bl);
    }

    public boolean isModal() {
        return this.wizardDialog.isModal();
    }

    public int showModalDialog() {
        this.wizardDialog.setModal(true);
        this.wizardDialog.pack();
        if (this.wizardDialog.getParent() != null) {
            this.wizardDialog.setLocationRelativeTo(this.wizardDialog.getParent());
        }
        this.wizardDialog.show();
        return this.returnCode;
    }

    public WizardModel getModel() {
        return this.wizardModel;
    }

    public void registerWizardPanel(Object object, WizardPanelDescriptor wizardPanelDescriptor) {
        this.cardPanel.add(wizardPanelDescriptor.getPanelComponent(), object);
        wizardPanelDescriptor.setWizard(this);
        this.wizardModel.registerPanel(object, wizardPanelDescriptor);
    }

    public void setCurrentPanel(Object object) {
        WizardPanelDescriptor wizardPanelDescriptor;
        if (object == null) {
            this.close(2);
        }
        if ((wizardPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor()) != null) {
            wizardPanelDescriptor.aboutToHidePanel();
        }
        this.wizardModel.setCurrentPanel(object);
        this.wizardModel.getCurrentPanelDescriptor().aboutToDisplayPanel();
        this.cardLayout.show(this.cardPanel, object.toString());
        this.wizardModel.getCurrentPanelDescriptor().displayingPanel();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("currentPanelDescriptorProperty")) {
            this.wizardController.resetButtonsToPanelRules();
        } else if (propertyChangeEvent.getPropertyName().equals("nextButtonTextProperty")) {
            this.nextButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("backButtonTextProperty")) {
            this.backButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("cancelButtonTextProperty")) {
            this.cancelButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("nextButtonEnabledProperty")) {
            this.nextButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("backButtonEnabledProperty")) {
            this.backButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("cancelButtonEnabledProperty")) {
            this.cancelButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("finishButtonEnabledProperty")) {
            this.finishButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public boolean getBackButtonEnabled() {
        return this.wizardModel.getBackButtonEnabled();
    }

    public void setBackButtonEnabled(boolean bl) {
        this.wizardModel.setBackButtonEnabled(new Boolean(bl));
    }

    public boolean getNextFinishButtonEnabled() {
        return this.wizardModel.getNextFinishButtonEnabled();
    }

    public void setNextFinishButtonEnabled(boolean bl) {
        this.wizardModel.setNextFinishButtonEnabled(new Boolean(bl));
    }

    public boolean getCancelButtonEnabled() {
        return this.wizardModel.getCancelButtonEnabled();
    }

    public void setCancelButtonEnabled(boolean bl) {
        this.wizardModel.setCancelButtonEnabled(new Boolean(bl));
    }

    void close(int n) {
        this.returnCode = n;
        this.wizardDialog.dispose();
    }

    private void initComponents() {
        this.wizardModel.addPropertyChangeListener(this);
        this.wizardController = new WizardController(this);
        this.wizardDialog.getContentPane().setLayout(new BorderLayout());
        this.wizardDialog.addWindowListener(this);
        JPanel jPanel = new JPanel();
        JSeparator jSeparator = new JSeparator();
        Box box = new Box(0);
        this.cardPanel = new JPanel();
        this.cardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.backButton = new JButton(BACK_TEXT);
        this.nextButton = new JButton(NEXT_TEXT);
        this.cancelButton = new JButton(CANCEL_TEXT);
        this.finishButton = new JButton(FINISH_TEXT);
        this.backButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        this.nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this.finishButton.setActionCommand(FINISH_BUTTON_ACTION_COMMAND);
        this.backButton.addActionListener(this.wizardController);
        this.nextButton.addActionListener(this.wizardController);
        this.cancelButton.addActionListener(this.wizardController);
        this.finishButton.addActionListener(this.wizardController);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jSeparator, "North");
        box.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        box.add(this.backButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.nextButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(this.finishButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.cancelButton);
        jPanel.add((Component)box, "East");
        this.wizardDialog.getContentPane().add((Component)jPanel, "South");
        this.wizardDialog.getContentPane().add((Component)this.cardPanel, "Center");
    }

    private static Object getImage(String string) {
        URL uRL = null;
        try {
            Class<?> clazz = Class.forName("cgdp.recog.wizard.Wizard");
            uRL = clazz.getResource(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Unable to find Wizard class");
        }
        return uRL;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.returnCode = 1;
    }
}

