/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.wizard;

import cgdp.recog.wizard.Wizard;
import cgdp.recog.wizard.WizardModel;
import cgdp.recog.wizard.WizardPanelDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WizardController
implements ActionListener {
    private Wizard wizard;

    public WizardController(Wizard wizard) {
        this.wizard = wizard;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("CancelButtonActionCommand")) {
            this.cancelButtonPressed();
        } else if (actionEvent.getActionCommand().equals("BackButtonActionCommand")) {
            this.backButtonPressed();
        } else if (actionEvent.getActionCommand().equals("NextButtonActionCommand")) {
            this.nextButtonPressed();
        } else if (actionEvent.getActionCommand().equals("FinishButtonActionCommand")) {
            this.finishButtonPressed();
        }
    }

    private void cancelButtonPressed() {
        this.wizard.close(1);
    }

    private void nextButtonPressed() {
        WizardModel wizardModel = this.wizard.getModel();
        WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanelDescriptor();
        Object object = wizardPanelDescriptor.getNextPanelDescriptor();
        if (object instanceof WizardPanelDescriptor.FinishIdentifier) {
            this.wizard.close(0);
        } else {
            this.wizard.setCurrentPanel(object);
        }
    }

    private void finishButtonPressed() {
        this.wizard.close(0);
    }

    private void backButtonPressed() {
        WizardModel wizardModel = this.wizard.getModel();
        WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanelDescriptor();
        Object object = wizardPanelDescriptor.getBackPanelDescriptor();
        this.wizard.setCurrentPanel(object);
    }

    void resetButtonsToPanelRules() {
        WizardModel wizardModel = this.wizard.getModel();
        WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanelDescriptor();
        wizardModel.setCancelButtonText(Wizard.CANCEL_TEXT);
        wizardModel.setBackButtonText(Wizard.BACK_TEXT);
        if (wizardPanelDescriptor.getBackPanelDescriptor() != null) {
            wizardModel.setBackButtonEnabled(Boolean.TRUE);
        } else {
            wizardModel.setBackButtonEnabled(Boolean.FALSE);
        }
        if (wizardPanelDescriptor.getNextPanelDescriptor() != null && !wizardPanelDescriptor.canFinish()) {
            wizardModel.setNextFinishButtonEnabled(Boolean.TRUE);
        } else {
            wizardModel.setNextFinishButtonEnabled(Boolean.FALSE);
        }
        wizardModel.setFinishButtonEnabled(new Boolean(wizardPanelDescriptor.canFinish()));
    }
}

