#!/usr/bin/perl -s

#
# Usage : $0 [-defaulttab] filename
#

use MBGD;
require "MBGD_Conf.pl";

$filename = $ARGV[0];

$FDELIM = '#@#';

open(F, $filename) || die "Can't open $filename($!)";

$dbname = $ENV{'MYSQL_DBTMP'} if (! $dbname);
if (! $tabID) {
	($tabID) = ($filename =~ /(\d+)$/);
}
if ($defaulttab) {
    require "MBGD_commonUpdate.pl";
    $dbname = $UPD_dbiTmp;
}
$tmpout = "$DIR_tmp/tmpdbout2.$$";

open(OUT, ">$tmpout") || die "Can't open $tmpout\n";

while (<F>) {
	if (/^#\s*(.*)$/) {
		$cmd = $1;
		($spec) = ($cmd =~ /\-SPEC=(\S+)/);
		@spec = split(/,/, $spec);
		$numspec = 0+@spec;
	} else {
		chomp;
		my ($clust, $num, @data) = split(/\t/);
		my ($pat, $spcnt, $orfcnt);
		foreach $g (@data[0..$numspec-1]) {
			if ($g) {
				$pat .= '1';
				$spcnt++;
			} else {
				$pat .= '0';
			}
			@g = split(/ /, $g);
			$orfcnt += (0+@g);
		}

		$gene = $data[$numspec];

#		print OUT join($FDELIM, $clust, $pat, $dbFunc, $class, $spcnt, $orfcnt, $gene, $_), "\n";
		print OUT join($FDELIM, $clust, $pat, $spcnt, $orfcnt, $gene, $_), "\n";
	}
}
close(OUT);
close(F);

$db = MBGD::DB->new($dbname);

$sql = "drop table if exists clusttab_$tabID";
$db->execute($sql);
$sql = "create table clusttab_$tabID ("
     . "clustid  int not null,"
     . "phylopat text not null,"
     . "spnum    int,"
     . "orfnum   int,"
     . "gene     varchar(24),"
     . "mbgd     varchar(24),"
     . "cog      varchar(24),"
     . "kegg     varchar(24),"
     . "tigr     varchar(24),"
     . "data     mediumtext,"
     . "primary key (clustid))";
$db->execute("$sql");
$sql = "load data local infile '$tmpout' "
     . "into table clusttab_$tabID "
     . "fields terminated by '$FDELIM' "
     . "(clustid, phylopat, spnum, orfnum, gene, data)";
print STDERR "DBG :: $sql\n";
$db->execute($sql);

if (-e "$main::FILE_category") {
    $sql = "drop table if exists clustcat_$tabID";
    $db->execute($sql);
    $sql = "create table clustcat_$tabID (
		clustid int not null,
		dbname varchar(16),
		class varchar(24),
		weight float,
		is_best smallint,
		primary key (clustid, dbname, class),
        key (clustid))";
    $db->execute("$sql");
    $sql = "load data local infile '$main::FILE_category' "
         . "into table clustcat_$tabID "
         . "fields terminated by '\t'";
    print STDERR "DBG :: $sql\n";
    $db->execute($sql);

    foreach my$db_cat ('mbgd', 'cog', 'kegg', 'tigr') {
        $sql = "update clusttab_$tabID ct, clustcat_$tabID cc "
         . "set ct.$db_cat=cc.class "
         . "where ct.clustid=cc.clustid and cc.dbname='$db_cat' and cc.is_best=1";
        print STDERR "DBG :: $sql\n";
        $db->execute($sql);
    }
}

undef($db); # DB ؤΥλ


unlink("$tmpout");


