#!/usr/bin/perl -s

use DBI;
use PGPLOT;
use MBGD;
use dotplot;
require 'MBGD_Conf.pl';

## file/cps for postscript output
$OUT = '/xserv' if (! $OUT);
$MAXGNDRW=100000;
$MAXGNAMDRW=20000;

$dbname = ($ENV{'MYSQL_DB'} || $MYSQL_DB);
$db = DBI->connect("$dbname",$User,$PW);


$sp1 = $ARGV[0];
$sp2 = $ARGV[1];

($sp1,$seq1) = split(/\-/, $sp1);
($sp2,$seq2) = split(/\-/, $sp2);

#@Color = (4, 3, 5, 1, 0, 0, 0, 0, 0, 2);
@Color = (4, 2, 5, 1, 0, 0, 0, 0, 0, 2);

$len1 = &read_chromosome($sp1, $seq1);
$len2 = &read_chromosome($sp2, $seq2);


if ($tabid) {
	($clusttab,$selected) = &read_clusttab($sp1,$sp2,$tabid,{
			phylopat=>$phylopat, mismatch=>$mismatch
		});
}

$GENE1 = []; $Gnames1 = {};
$GENE2 = []; $Gnames2 = {};
($GENE1, $Gnames1, $Gn1) = &readgene('gene', $sp1);
($GENE2, $Gnames2, $Gn2) = &readgene('gene', $sp2);

$XLAB = $sp1 if (! $XLAB);
$YLAB = $sp2 if (! $YLAB);
$minx = 1 if (! $minx);
$miny = 1 if (! $miny);
$maxx = $len1 if (! $maxx);
$maxy = $len2 if (! $maxy);


$ENV{'PGPLOT_BACKGROUND'} = 'white';
$ENV{'PGPLOT_FOREGROUND'} = 'black';

pgbegin(0, "$OUT", 1, 1);
pgsch(1);
pgscf(2);
pgsci(1);
pgslw(1);

&read_data($sp1,$sp2);

$Minx = $minx; $Miny = $miny;
$Maxx = $maxx; $Maxy = $maxy;
pgask(0);
push(@History, [$minx,$maxx,$miny,$maxy]);

if ($OUT eq '/xserv') {
    do {
	pgenv($minx, $maxx, $miny, $maxy, 1, 0);
	pglabel($XLAB, $YLAB, $TITLE);
#	print "$minx,$maxx,$miny,$maxy\n";
	&plot;
	&print_gene if ($maxx-$minx<$MAXGNDRW && $maxy-$miny<$MAXGNDRW);
	pgcurs($x1, $y1, $dmy);
	if ($dmy =~ /[Oo]/) { 
		($minx,$maxx,$miny,$maxy) = ($Minx,$Maxx,$Miny,$Maxy);
	} elsif ($dmy =~ /[Nn]/) { 
		$gnameout = 1 - $gnameout;
	} elsif ($dmy =~ /[Pp]/) { 
		pgbegin(0, '/cps', 1, 1);
		&plotout;
		$exit = 1;
	} elsif ($dmy =~ /</) { 
		$hptr-- if ($hptr > 0);
		($minx,$maxx,$miny,$maxy) = @{$History[$hptr]};
	} elsif ($dmy =~ />/) { 
		$hptr++ if ($hptr < $#History);
		($minx,$maxx,$miny,$maxy) = @{$History[$hptr]};
	} else {
		$x2 = $x1; $y2 = $y1;
		pgband(2, 1, $x1, $y1, $x2, $y2, $dmy);
		($minx,$maxx) = sort($x1,$x2); ($miny,$maxy) = sort($y1,$y2);
		$x1 = $x2; $y1 = $y2;
		if ($hptr < $#History) {
			splice(@History, $hptr+1);
		}
		push(@History, [$minx,$maxx,$miny,$maxy]);
		$hptr++;
	}
    } while (! $exit);
} elsif ($OUT =~ /\/gif$/) {
	pgenv($minx, $maxx, $miny, $maxy, 1, 0);
	pglabel($XLAB, $YLAB, $TITLE);
	&legend;
#	print "$minx,$maxx,$miny,$maxy\n";
	&plot;
	if ($maxx-$minx<$MAXGNAMDRW && $maxy-$miny<$MAXGNAMDRW) {
		$gnameout=1;
	} else {
		$gnameout=0;
	}
	&print_gene if ($maxx-$minx<$MAXGNDRW && $maxy-$miny<$MAXGNDRW);
	&print_rep;
}

pgend;
