#!/usr/bin/perl -s
require 'MBGD_Conf.pl';
use MBGD;
use MbgdUserGenomeCommon;

$tabid = $ARGV[0];
die if (! $tabid);

if ($uid=$ARGV[1]) {
	&MbgdUserGenomeCommon::setupUserGenomeEnv($uid);
}
$dbtmp = MBGD::DB->new($ENV{'MYSQL_DBTMP'});
$sql = "select spec from cluster_tables where tabid='$tabid'";
$sth = $dbtmp->execute($sql);

($speclist) = $sth->fetchrow_array;
@speclist = split(/,/, $speclist);

my(@field_name_list) = ("ClusterID",
                        "Size",
                        @speclist,
                        "Gene",
                        "FuncCat(mbgd)",
                        "FuncCat(cog)",
                        "FuncCat(kegg)",
                        "FuncCat(tigr)",
                        );

my(%annotsp_descr);
if ($add_annotsp) {
    $add_annotsp = lc($add_annotsp);

    #
    my($idx) = 2;
    my(%sp2idx);
    foreach my$sp (@speclist) {
        my($lcsp) = lc($sp);
        $sp2idx{"$lcsp"} = $idx;
        $idx++;
    }
    $annotsp_idx = $sp2idx{"$add_annotsp"};
    if ($annotsp_idx ne '') {
        push(@field_name_list, 'annotsp');

        my($opt) = {};
        $opt->{'colmns'} = "sp,name,descr";
        my(@gene_list) = MBGD::Gene->get($add_annotsp, $opt);
        foreach my$ref (@gene_list) {
            my($sp)    = $ref->{'sp'};
            my($name)  = $ref->{'name'};
            my($descr) = $ref->{'descr'};

if ($descr =~ /^hypothetical protein$/i) {
    next;
}

            $annotsp_descr{"$sp:$name"} = $descr;
        }
    }
    else {
        undef($add_annotsp);
    }
}

#
print join("\t", @field_name_list),"\n";

#
$sql = "select data,mbgd,cog,kegg,tigr from clusttab_$tabid";
$sth = $dbtmp->execute($sql);
while (@out = $sth->fetchrow_array) {
    if ($add_annotsp) {
        my($descr) = '';
        my(@sp_orf_list) = split(/\t/, $out[0]);
        my($sp_orf) = $sp_orf_list[$annotsp_idx];
        my(@spname_list) = split(/\s/, $sp_orf);
        foreach my$spname (@spname_list) {
            $spname =~ s#\(\d+\)$##;
            if (length($descr) < length($annotsp_descr{"$spname"})) {
                $descr = $annotsp_descr{"$spname"};
            }
        }
        push(@out, $descr);
    }

	print join("\t", @out), "\n";
}
