#!/usr/bin/perl -s
use CGI qw/ :standard start_table end_table /;
use RECOG;
use RECOG::DomClustCommon;
use RECOG::MBGD::DomClust;
use RECOG::MBGD::ClusterTable;
use RECOG::MBGD::OutputDomClust;
use MBGD::DB;
use MBGD::Taxonomy;

###############################################################################
#
sub delete_core {
    my($id_core) = shift;

    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);
    foreach $cid (split(/,\s*/, $id_core)) {
    	deleteCoreAlignerCacheTable($db, $cid);
    }

    print "Content-type: text/html\n";
    print "\n";

    print "<html>\n";
    print "<head>\n";
    print '<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />', "\n";
    print "</head>\n";
    print "\n";
    print "<body>\n";
    print "\n";
    print "<a href=\"/htbin/RECOG/list_core.cgi\">List cluster(s).</a>\n";
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($id_core) = $cgi->param('id_core');

    delete_core($id_core);
}

###############################################################################
1;#
###############################################################################
