#!/usr/bin/perl -s

use MBGD::WWW;

require "MBGD_Conf.pl";
require "libMBGDaxes.pl";
require "emergency.pl";

##require "libCGI.pl";
##require "libHTML.pl";

$WWW = MBGD::WWW->new;
%Args = $WWW->cgiGetArgs;

###%Args = &CGI_GetArgs;
$sp  = $Args{'sp'};
$orf = $Args{'orf'};
$type = $Args{'type'};
$format = $Args{'format'};
if ($Args{name} =~ /:/) {
	($sp,$orf) = split(/:/, $Args{name});
}

$seq = &MBGD_GetGeneSequence($sp, $orf, $type);

if ($format eq 'fasta') {
	print "Content-type: text/plain\n\n";
	print ">$sp:$orf\n";
} else {
	$WWW->start_html(title=>"$Args{type} sequence");
	print "<PRE>\n";
}


#if ($format eq 'fasta') {
#} else {
#print "<HTML>\n";
#print "<HEAD>\n";
#print "<TITLE>Search results</TITLE>\n";
#print "</HEAD>\n";
#print "\n";
#print "<BODY bgcolor=\"#f0fff0\">\n";
#print "<PRE>";
#}


# insert a newline each 60 characters
$seq =~ s#(.{60})#$1\n#g;
print "$seq";

#chomp($seq);
#
#$idx = 1;
#foreach $s (split(/\n/, $seq)) {
#    printf("%9d  %s\n", $idx, $s);
#    $idx += 60;
#	print "$s\n";
#}

if ($format ne 'fasta') {
	print "</PRE>";
	$WWW->end_html;
}

exit 0;

###############################################################################
# input : sp, orf
# return: ID
sub main::MBGD_GetGeneSequence {
    my($sp, $orf, $type) = @_;

    my($dbname);
    my($db);
    my($tab, $opt);

    $dbname = $ENV{'MYSQL_DB'};
    $db = MBGD::DB->new($dbname);
    $opt->{'where'} = "g.sp='$sp' and g.name='$orf'";

    $opt->{'columns'} = "s.seq seq";
    if ($type eq 'nucleotide') {
    	$tab = "gene g, geneseq s";
	$opt->{'where'} .= " and g.ntseq=s.id";
    } else {
    	$tab = "gene g, proteinseq s";
	$opt->{'where'} .= " and g.aaseq=s.id";
    }

    $res = $db->select_fetch($tab, $opt);
    my($ent) = @{$res->{'INFO'}};

    return $ent->{'seq'};
}

###############################################################################
#1;#
###############################################################################
