#!/usr/bin/perl -s
use strict;
use CGI;
use FileHandle;
use GDBM_File;

###############################################################################
#
sub unpack_select {
    my($fh) = shift;
    my($fp2) = shift;

    my($PACK_TEMPL) = "a38 a38 S S S S f f f f";
    my($pd) = pack($PACK_TEMPL, 'A', 'B', 1, 2, 3, 4, 5, 6, 7, 8);
    my($sizePd) = length($pd);

    my($buf);
    while (read($fh, $buf, $sizePd)) {
        my(@res) = unpack($PACK_TEMPL, $buf);
        $res[0] =~ s#\x0##g;
        $res[1] =~ s#\x0##g;
        print "@res\n";

        my($fp1) = $fh->tell();
        if ($fp2 <= $fp1) {
            last;
        }
    }

    return;
}

###############################################################################
#
sub print_select {
    my($filename) = shift;
    my($fp1) = shift;
    my($fp2) = shift;

    my($fh) = FileHandle->new("$filename") || die("Can not open $filename($!)");
    $fh->seek($fp1, 0);
    unpack_select($fh, $fp2);
    $fh->close();

    return;
}

###############################################################################
#
sub getDataHomology {
    my($sp1) = shift;
    my($sp2) = shift;

    my(%Hash);
    my($filename) = "spindex";
    tie(%Hash, 'GDBM_File', $filename, &GDBM_READER, 0640);

    #
    my(@pair_list) = ("$sp1:$sp2");
    push(@pair_list, "$sp2:$sp1") if ($sp1 ne $sp2);
    foreach my$pair (@pair_list) {
        my($spindex) = $Hash{"$pair"};
        if (!$spindex) {
            print STDERR "DBG :: Not found $pair\n" if ($main::DEBUG);
            next;
        }

        my($file, $fp1, $fp2) = split(':', $spindex);
        print STDERR "DBG :: $file : $fp1 : $fp2\n" if ($main::DEBUG);
        print "#", $pair, "\n";
        print_select($file, $fp1, $fp2);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    #
    my($species);
    if ($main::SPEC) {
        $species = $main::SPEC;
    }
    else {
        my($cgi) = CGI->new();
        $species = $cgi->param('species');
    }
    my(@spec_list) = sort(split(/,/, $species));
    my($n_spec) = scalar(@spec_list);

    #
    my($dir) = sprintf("%s/database/bldp", $ENV{'MBGD_HOME'});
    chdir($dir);

    #
    print "Content-type: text/plain\n";
    print "\n";

    #
    for (my$i=0; $i < $n_spec; $i++) {
        my($sp1) = $spec_list[$i];
        for (my$j=$i; $j < $n_spec; $j++) {
            my($sp2) = $spec_list[$j];
            getDataHomology($sp1, $sp2);
        }
    }
}

###############################################################################
1;#
###############################################################################
