#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use MBGD::DB;
use RecogProjectCommon;
use RecogBuild;
require "MBGD_Conf.pl";

###############################################################################
sub build_homology_all_win {
    my($formOpt) = shift;

    my($user) = $ENV{'REMOTE_USER'};
    my($proj_id) = $formOpt->{'project_id'};

    #
    my($dbname) = $main::DBNAME_ACCUM;
    my($db) = MBGD::DB->new($dbname);
#    my($proj_ref) = RecogProjectCommon::get_project_domclust($db, $proj_id, $user);
    my($auth) = RECOG::RecogProject->new();
    my($proj_ref) = $auth->get_project($user, $proj_id);
    my($proj_name) = $proj_ref->{PROP}->{'name'};

    #
    my(@spid_list) = split(/ /, $proj_ref->{PROP}->{'spid'});

    #
    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_build.js"></script>
<script language="JavaScript" src="/js/recog_project.js"></script>
<script type="text/javascript" src="/js/recog_common.js"></script>

</head>

<body>

<h1>Build homology database</h1>
EOB

    if (scalar(@spid_list) == 0) {
        print <<EOB;
<h2>No species</h2>
</body>
</html>
EOB
        return;
    }

    #
    my(@no_download_spid) = RecogBuild::check_nodownload_species(@spid_list);
    if (scalar(@no_download_spid) != 0) {
        print <<EOB;
<h2>Some species were not downloaded.</h2>
Please check [<a href="/htbin/recog_build/list_species_win.cgi" onclick="parent.build_menu.list_species_win(); return false; ">List Species</a>]
</body>
</html>
EOB
        return;
    }
	print <<EOB;
<ol>
    <li>Extract sequences</li>
    <li>BLAST/DP alignment</li>
    <li>Insert homology resuts into MySQL</li>
    <li>Build homology DB</li>
</ol>
EOB


    print <<EOB;
<form method="post">
<input type="button" name="btn_build_homology" value="Build homology databse" onclick="">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    foreach my$key ('project_id') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    build_homology_all_win($formOpt);
}

###############################################################################
1;#
###############################################################################
