#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub del_public_spec {
    my($formOpt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($proj_id) = $formOpt->{'project_id'};
    my($del_spid) = $formOpt->{'spid'};

    #
    my($dbname) = $main::DBNAME_ACCUM;
    my($db) = MBGD::DB->new($dbname);
    my($proj_ref) = RecogProjectCommon::get_project($db, $proj_id, $user);
    if ($proj_ref) {
        my(%spid_hash);
        my(@spid_list) = split(/,/, $proj_ref->{'spid'});
        foreach my$spid (@spid_list) {
            $spid_hash{"$spid"} = 1;
        }
        delete($spid_hash{"$del_spid"});

        $proj_ref->{'spid'} = join(',', sort(keys(%spid_hash)));
        RecogProjectCommon::edit_project($db, $proj_id,
                                              $proj_ref->{'descr'},
                                              $proj_ref->{'spid'});
    }

    $ENV{'QUERY_STRING'} = "project_id=$proj_id";
    my($cmd) = "list_species_win.cgi";
    exec($cmd);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();
    my($formOpt) = {};
    foreach my$key ('project_id', 'spid') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    del_public_spec($formOpt);
}

###############################################################################
1;#
###############################################################################
