#!/usr/bin/perl -s
use strict;
use CGI;
use FileHandle;
use IO::File;
use MBGD::DB;
use MbgdUserGenomeCommon;
use RecogBuild;
use RecogProjectCommon;
use RECOG::RecogProject;
require "InfoSpec.pl";

###############################################################################
#
sub rename_spec_for_spid {
    my($file_spidtab) = shift;
    my($spid) = shift;
    my($spec) = shift;

    if (! -e "$file_spidtab") {
        return;
    }

    my($file_spidtab_new) = "$file_spidtab.$$";
    my($fhr) = IO::File->new("$file_spidtab") || die("Can not open $file_spidtab($!)");
    my($fhw) = IO::File->new(">$file_spidtab_new") || die("Can not open $file_spidtab_new($!)");
    while (my$line=$fhr->getline()) {
        next if ($line =~ /^\s*$/);
        next if ($line =~ /^\s*#/);

        my($spid0, $spec0, $name) = split(/\t/, $line);
        if ($spid0 eq $spid) {
            $line = join("\t", $spid, $spec, $name);
        }
        $fhw->print($line);
    }
    $fhw->close();
    $fhr->close();

    #
    unlink("$file_spidtab.bak") if (-e "$file_spidtab.bak");
    rename("$file_spidtab", "$file_spidtab.bak");
    rename("$file_spidtab_new", "$file_spidtab");

    return;
}

###############################################################################
#
sub create_user_genome {
    my($spec) = shift;

    my($spid) = RecogBuild::get_new_spid();
    if (!$spid) {
        return;
    }

    #
    my($cmd) = "$ENV{'RECOG_HOME'}/build/createUgSkeleton.pl -spid='$spid' -sp='$spec' -nchr=1";
    system("$cmd");

    return $spid;
}

###############################################################################
#
sub reedit_user_genome {
    my($formOpt) = shift;

    return;
}

###############################################################################
#
sub mod_user_genome {
    my($formOpt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($auth) = RECOG::RecogProject->new();
    my($sta) = $auth->permit_project_user($user,
                                          $RECOG::RecogProject::ID_PRJ_system,
                                          $RECOG::RecogProject::ACT_ADD_PRJ);
    if (!$sta) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($spid) = $formOpt->{'spid'};
    my($spec) = $formOpt->{'sp'};

    my($ug_ref);
    if (!$spid && !$spec) {
        my($opt) = {};
        RecogBuild::add_user_genome_win($opt);
        exit(0);
    }
    elsif (!$spid) { # NEW species
        #
        my($file_spid_tab) = "$ENV{'RECOG_HOME'}/etc/spid.tab";
        my($spid_tab_ref) = getInfoSpecTab($file_spid_tab);
        my($file_spid_tab_dist) = "$ENV{'RECOG_HOME'}/etc/spid.tab.dist";
        my($spid_tab_dist_ref) = getInfoSpecTab($file_spid_tab_dist);
        if (exists($spid_tab_ref->{'NAME2DIR'}->{"$spec"})) {
            # already used.
            $formOpt->{'MESSAGE'} = "Sorry, already used. ($spec)\n";
        }
        elsif (exists($spid_tab_dist_ref->{'NAME2DIR'}->{"$spec"})) {
            # already used.
            $formOpt->{'MESSAGE'} = "Sorry, already used. ($spec)\n";
        }
        else {
            $spid = create_user_genome($spec);
        }
    }
    else { # Edit species
        #
        my($file_spid_tab) = "$ENV{'RECOG_HOME'}/etc/spid.tab";
        my($spid_tab_ref) = getInfoSpecTab($file_spid_tab);
        my($file_spid_tab_dist) = "$ENV{'RECOG_HOME'}/etc/spid.tab.dist";
        my($spid_tab_dist_ref) = getInfoSpecTab($file_spid_tab_dist);

        #
        $ug_ref = RecogBuild::load_user_genome($spid);

        #
        if ($spec ne $ug_ref->{'sp'}) {
            if (exists($spid_tab_ref->{'NAME2DIR'}->{"$spec"})) {
                # already used.
                $formOpt->{'MESSAGE'} = "Sorry, already used. ($spec)\n";
             }
            elsif (exists($spid_tab_dist_ref->{'NAME2DIR'}->{"$spec"})) {
                # already used.
                $formOpt->{'MESSAGE'} = "Sorry, already used. ($spec)\n";
            }
            else {
                my($file_spec) = "$ENV{'RECOG_HOME'}/species/$spec";
                my($file_spid) = "$ENV{'RECOG_HOME'}/species/$spid";
                if ($ug_ref->{'sp'}) {
                    my($file_spec_old) = "$ENV{'RECOG_HOME'}/species/" . $ug_ref->{'sp'};
                    if (-e $file_spec_old) {
                        unlink($file_spec_old);
                    }
                }
                if ($spec) {
                    #
                    symlink($file_spid, $file_spec);

                    # update spid.tab
                    my($file_spid_tab) = "$ENV{'RECOG_HOME'}/etc/spid.tab";
                    rename_spec_for_spid($file_spid_tab, $spid, $spec);
                }
            }
        }

        foreach my$k (keys(%{$ug_ref})) {
            if ($formOpt->{"$k"} =~ /^\s*$/) {
                $formOpt->{"$k"} = $ug_ref->{"$k"};
            }
        }
        if (!$formOpt->{'taxid'}) {
            $formOpt->{'taxid'} = 32644; # set 'unknown' taxonomy id.
        }

        #
        my(@uc_list) = RecogBuild::load_user_chromosome_list($spid);
        my(@uc_id_list);
        foreach my$uc_ref (@uc_list) {
            push(@uc_id_list, $uc_ref->{'seqno'});
        }
        $formOpt->{'uc_id_list'} = join(',', @uc_id_list);
    }

    #
    RecogBuild::save_user_genome($spid, $formOpt);

    #
    my(@uc_id_list) = split(/,/, $formOpt->{'uc_id_list'});
    foreach my$uc_id (@uc_id_list) {
        if ($uc_id == $formOpt->{'del_chromosome'}) {
            RecogBuild::remove_user_chromosome($spid, $uc_id);
            next;
        }

        RecogBuild::save_user_chromosome($spid, $uc_id, $formOpt);
    }

    #
    if ($formOpt->{'more_chromosome'}) {
        RecogBuild::create_user_chromosome($spid);
    }

    #
    my($opt) = {};
    $opt->{'spid'} = $spid;
    RecogBuild::add_user_genome_win($opt);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    foreach my$key ('spid', 'orgname', 'abbrev', 'sp', 'strain', 'taxid',
                    'uc_id_list',
                    'more_chromosome', 'chromosome_data_type',
                    'del_chromosome') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    if ($formOpt->{'spid'} =~ /^gu\d+$/) {
        my(@uc_id_list) = split(/,/, $formOpt->{'uc_id_list'});
        foreach my$uc_id (@uc_id_list) {
            if ($uc_id == $formOpt->{'del_chromosome'}) {
                next;
            }

            foreach my$k ('name', 'multi_locus', 'file_gbk', 'shape', 'length', 'file_gene_table', 'file_protein', 'file_dna') {
                my($key) = join('_', $k, 'uc', $uc_id);
                $formOpt->{"$key"} = $cgi->param($key);

                if (($k eq 'name') && ($formOpt->{"$key"} =~ /^\s*$/)) {
                    $formOpt->{"$key"} = "name-$uc_id";
                }
            }
        }
    }
    else {
        delete($formOpt->{'spid'});
    }

    mod_user_genome($formOpt);
}

###############################################################################
1;#
###############################################################################
