#!/usr/bin/perl -s
use strict;

sub update_gold_win {
    print "Content-type: text/html\n";
    print "\n";

    my($dir) = "$ENV{'RECOG_HOME'}/database.work";
    my($file_gold) = "$dir/gold_published_table.txt";
    my($tm_gold) = 'Not found';
    if (-e $file_gold) {
        my(@stat_list) = stat($file_gold);
        my($sec, $min, $hour, $mday, $mon, $year) = localtime($stat_list[9]);
        $year += 1900;
        $mon++;
        $tm_gold = sprintf("%04d/%02d/%02d", $year, $mon, $mday);
    }

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>

<body>

<div id="id_msg">
<h1>Update GOLD</h1>
Download GOLD from <a href="http://www.genomesonline.org/DBs/gold_published_table.txt">www.genomesonline.org</a><br />
<p>
timestamp : $tm_gold<br>
</div>

<form name="frm_update_gold" method="post">
<input type="button" name="btn_update_gold" value="Update" onclick="update_gold();">
</form>
</body>
</html>
EOB

    return;
}

################################################################################
if ($0 eq __FILE__) {
    update_gold_win();
}
1;#
