#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use MBGD::DB;
use RecogProjectCommon;
use RecogBuild;
use RECOG::RecogProject;
require "MBGD_Conf.pl";

###############################################################################
sub update_mysql_species_win {
    my($formOpt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my(%spid_hash);
    my($recog_proj_ref) = RECOG::RecogProject->new();
    my(@all_spid_list)    = $recog_proj_ref->get_spid_list_all($user);
    my(@all_spid_list_bc) = $recog_proj_ref->get_spid_list_all_base_cluster($user);

    #
    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_build.js"></script>
<script language="JavaScript" src="/js/recog_project.js"></script>
<script type="text/javascript" src="/js/recog_common.js"></script>

</head>

<body>

<h1>Update mysql</h1>
EOB

    if (scalar(@all_spid_list, @all_spid_list_bc) == 0) {
        print <<EOB;
<h2>No species in the current projects</h2>
</body>
</html>
EOB
        return;
    }

    #
    my(@no_download_spid) = RecogBuild::check_nodownload_species(@all_spid_list, @all_spid_list_bc);
    my($n) = scalar(@no_download_spid);
    my($btn_val) = '';
    if ($n == 0) {
        print "<h2>All species were downloaded.</h2>\n";
    }
    else {
        print "<h2>$n species were not downloaded.</h2>\n";
        print "species :: " . join(',', @no_download_spid) . "\n";
        $btn_val .= 'Download / ';
    }
    my($Message_forceRebuild_insert, $Message_forceRebuild_extract, $Message_useChkpnt);
    my($chkpnt_insert) = <$main::DIR_work/.m0420*.end>;
    if ($chkpnt_insert) {
	$Message_forceRebuild_insert = qq{<input type="checkbox" name="force_rebuild_insert" value="on"> Force to re-insert all data (ignoreing checkpoint)<br>};
    }
    my($chkpnt_extract) = <$main::DIR_work/.m04[5-9]0*.end>;
    if ($chkpnt_extract) {
	$Message_forceRebuild_extract = qq{<input type="checkbox" name="force_rebuild_extract" value="on"> Force to re-extract sequences (ignoring checkpoint)<br>};
    }

    my($chkpntfile) = <$main::DIR_work/.m0400*.end>;
    if (-f $chkpntfile) {
	my(@stat) = stat $chkpntfile;
	my($sec,$min,$hour,$day,$mon,$year,$wday,$yday)  = localtime($stat[9]);
	my($date) = sprintf("%4d%02d%02d", 1900+$year, $mon+1, $day);
	$Message_useChkpnt = qq{<input type="checkbox" name="useChkpnt" checked value="on"> Extract as query sequences only those added after the last update [date: <input type="text" name="date" value="$date" size=8>] <br>};
    }

    $btn_val .= 'Update species';
    print <<EOB;
<form name="frm_update_species" method="post" action="/htbin/recog_build/update_mysql_species.cgi">
$Message_forceRebuild_insert
$Message_forceRebuild_extract
$Message_useChkpnt
<input type="submit" name="btn_update" value="$btn_val">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    foreach my$key ('project_id') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    update_mysql_species_win($formOpt);
}

###############################################################################
1;#
###############################################################################
